/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.core.RqueueBeanProvider;
import com.github.sonus21.rqueue.core.middleware.Middleware;
import com.github.sonus21.rqueue.listener.PostProcessingHandler;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.listener.RqueueMessagePoller;
import com.github.sonus21.rqueue.utils.QueueThreadPool;
import com.github.sonus21.rqueue.utils.TimeoutUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.event.Level;

class StrictPriorityPoller
extends RqueueMessagePoller {
    private final Map<String, QueueDetail> queueNameToDetail;
    private final Map<String, QueueThreadPool> queueNameToThread;
    private final Map<String, Long> queueDeactivationTime = new HashMap<String, Long>();
    private final Map<String, Long> lastFetchedTime = new HashMap<String, Long>();
    private static final String ALL_QUEUES_ARE_INELIGIBLE = "\ud83d\ude1f";
    private static final String ALL_QUEUES_ARE_INACTIVE = "\ud83d\udc4b";

    StrictPriorityPoller(String groupName, List<QueueDetail> queueDetails, Map<String, QueueThreadPool> queueNameToThread, RqueueBeanProvider rqueueBeanProvider, RqueueMessageListenerContainer.QueueStateMgr queueStateMgr, List<Middleware> middlewares, long pollingInterval, long backoffTime, PostProcessingHandler postProcessingHandler) {
        super("Strict-" + groupName, rqueueBeanProvider, queueStateMgr, middlewares, pollingInterval, backoffTime, postProcessingHandler);
        ArrayList<QueueDetail> queueDetailList = new ArrayList<QueueDetail>(queueDetails);
        queueDetailList.sort((o1, o2) -> o2.getPriority().get("DEFAULT_PRIORITY") - o1.getPriority().get("DEFAULT_PRIORITY"));
        this.queues = queueDetailList.stream().map(QueueDetail::getName).collect(Collectors.toList());
        this.queues.forEach(queue -> this.lastFetchedTime.put((String)queue, 0L));
        this.queueNameToDetail = queueDetailList.stream().collect(Collectors.toMap(QueueDetail::getName, Function.identity()));
        this.queueNameToThread = queueNameToThread;
    }

    private String getQueueToPoll() {
        long now = System.currentTimeMillis();
        for (String queue : this.queues) {
            if (!this.eligibleForPolling(queue) || now - this.lastFetchedTime.get(queue) <= 60000L) continue;
            return queue;
        }
        for (String queue : this.queues) {
            if (!this.eligibleForPolling(queue)) continue;
            Long deactivationTime = this.queueDeactivationTime.get(queue);
            if (deactivationTime == null) {
                return queue;
            }
            if (now - deactivationTime <= this.pollingInterval) continue;
            return queue;
        }
        return ALL_QUEUES_ARE_INELIGIBLE;
    }

    private String getQueueToPollOrWait() {
        String queueToPoll = this.getQueueToPoll();
        if (queueToPoll.equals(ALL_QUEUES_ARE_INELIGIBLE) && this.shouldExit()) {
            return ALL_QUEUES_ARE_INACTIVE;
        }
        this.log(Level.DEBUG, "Queue to be poll : {}", null, queueToPoll);
        return queueToPoll;
    }

    @Override
    public void start() {
        this.log(Level.DEBUG, "Running, Ordered Queues: {}", null, this.queues);
        while (true) {
            try {
                while (true) {
                    String queue;
                    if ((queue = this.getQueueToPollOrWait()).equals(ALL_QUEUES_ARE_INACTIVE)) {
                        return;
                    }
                    if (queue.equals(ALL_QUEUES_ARE_INELIGIBLE)) {
                        TimeoutUtils.sleepLog(this.pollingInterval, false);
                        continue;
                    }
                    this.lastFetchedTime.put(queue, System.currentTimeMillis());
                    QueueThreadPool queueThreadPool = this.queueNameToThread.get(queue);
                    QueueDetail queueDetail = this.queueNameToDetail.get(queue);
                    this.poll(-1, queue, queueDetail, queueThreadPool);
                }
            }
            catch (Exception e) {
                this.log(Level.ERROR, "Exception in the poller {}", e, e.getMessage());
                if (!this.shouldExit()) continue;
                return;
            }
            break;
        }
    }

    @Override
    long getSemaphoreWaitTime() {
        return 20L;
    }

    @Override
    void deactivate(int index, String queue, RqueueMessagePoller.DeactivateType deactivateType) {
        if (deactivateType == RqueueMessagePoller.DeactivateType.POLL_FAILED) {
            TimeoutUtils.sleepLog(this.backoffTime, false);
        } else {
            this.queueDeactivationTime.put(queue, System.currentTimeMillis());
        }
    }
}

