/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.core.RqueueBeanProvider;
import com.github.sonus21.rqueue.core.middleware.Middleware;
import com.github.sonus21.rqueue.listener.PostProcessingHandler;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.listener.RqueueMessagePoller;
import com.github.sonus21.rqueue.utils.QueueThreadPool;
import com.github.sonus21.rqueue.utils.TimeoutUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.event.Level;

class WeightedPriorityPoller
extends RqueueMessagePoller {
    private final Map<String, QueueThreadPool> queueNameToThread;
    private final Map<String, QueueDetail> queueNameToDetail;
    private final List<QueueDetail> queueDetailList;
    private int[] currentWeight;
    private int[] weight;
    private float[] probability;
    private int currentIndex = 0;
    private static final int ALL_QUEUES_ARE_INELIGIBLE = -1;
    private static final int ALL_QUEUES_ARE_INACTIVE = -2;

    WeightedPriorityPoller(String groupName, List<QueueDetail> queueDetails, Map<String, QueueThreadPool> queueNameToThread, RqueueBeanProvider rqueueBeanProvider, RqueueMessageListenerContainer.QueueStateMgr queueStateMgr, List<Middleware> middlewares, long pollingInterval, long backoffTime, PostProcessingHandler postProcessingHandler) {
        super("Weighted-" + groupName, rqueueBeanProvider, queueStateMgr, middlewares, pollingInterval, backoffTime, postProcessingHandler);
        this.queueDetailList = queueDetails;
        this.queues = queueDetails.stream().map(QueueDetail::getName).collect(Collectors.toList());
        this.queueNameToDetail = queueDetails.stream().collect(Collectors.toMap(QueueDetail::getName, Function.identity()));
        this.queueNameToThread = queueNameToThread;
    }

    private void initializeWeight() {
        int i;
        this.currentWeight = new int[this.queues.size()];
        this.weight = new int[this.queues.size()];
        this.probability = new float[this.queues.size()];
        float total = 0.0f;
        for (i = 0; i < this.queues.size(); ++i) {
            QueueDetail queueDetail = this.queueDetailList.get(i);
            this.currentWeight[i] = queueDetail.getPriority().get("DEFAULT_PRIORITY");
            this.weight[i] = this.currentWeight[i];
            total += (float)this.weight[i];
        }
        if (total == 0.0f) {
            throw new IllegalStateException("Total priority is zero!!");
        }
        for (i = 0; i < this.weight.length; ++i) {
            this.probability[i] = (float)this.weight[i] / total;
        }
    }

    private void reinitializeWeight() {
        this.currentIndex = 0;
        System.arraycopy(this.weight, 0, this.currentWeight, 0, this.weight.length);
        this.log(Level.DEBUG, "reinitialized weight {}", null, new Object[]{this.currentWeight});
    }

    private int getQueueIndexToPoll() {
        int tmpIndex = (this.currentIndex + 1) % this.queues.size();
        while (tmpIndex != this.currentIndex) {
            String queue = (String)this.queues.get(tmpIndex);
            if (this.currentWeight[tmpIndex] > 0 && this.eligibleForPolling(queue)) {
                int n = tmpIndex;
                this.currentWeight[n] = this.currentWeight[n] - 1;
                this.currentIndex = tmpIndex;
                return this.currentIndex;
            }
            tmpIndex = (tmpIndex + 1) % this.queues.size();
        }
        return -1;
    }

    private int getQueueToPollOrWait() {
        int index = this.getQueueIndexToPoll();
        if (index == -1) {
            if (this.shouldExit()) {
                return -2;
            }
            index = -1;
        }
        if (this.isDebugEnabled()) {
            if (index >= 0) {
                this.log(Level.DEBUG, "Polling queue: {}", null, this.queues.get(index));
            } else {
                this.log(Level.DEBUG, "No queue to poll", null, new Object[0]);
            }
        }
        return index;
    }

    private void printDebugDetail() {
        if (!this.isDebugEnabled()) {
            return;
        }
        List weightStr = Arrays.stream(this.currentWeight).mapToObj(String::valueOf).collect(Collectors.toList());
        this.log(Level.DEBUG, "Running Queues: {} Weight: {} Average: {}", null, this.queues, weightStr, this.probability);
    }

    @Override
    public void start() {
        this.initializeWeight();
        this.printDebugDetail();
        while (true) {
            try {
                while (true) {
                    int index;
                    if ((index = this.getQueueToPollOrWait()) == -2) {
                        return;
                    }
                    if (index == -1) {
                        TimeoutUtils.sleepLog(this.pollingInterval, false);
                        this.reinitializeWeight();
                        continue;
                    }
                    String queue = (String)this.queues.get(index);
                    QueueThreadPool queueThreadPool = this.queueNameToThread.get(queue);
                    QueueDetail queueDetail = this.queueNameToDetail.get(queue);
                    this.poll(index, queue, queueDetail, queueThreadPool);
                }
            }
            catch (Exception e) {
                this.log(Level.ERROR, "Error in poller", e, new Object[0]);
                if (!this.shouldExit()) continue;
                return;
            }
            break;
        }
    }

    @Override
    long getSemaphoreWaitTime() {
        return 25L;
    }

    @Override
    void deactivate(int index, String queue, RqueueMessagePoller.DeactivateType deactivateType) {
        if (deactivateType == RqueueMessagePoller.DeactivateType.POLL_FAILED) {
            TimeoutUtils.sleepLog(this.backoffTime, false);
        } else {
            int n = index;
            this.currentWeight[n] = (int)((float)this.currentWeight[n] - (float)this.currentWeight[index] * (1.0f - this.probability[index]));
        }
    }
}

