/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.metrics;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.exception.QueueDoesNotExist;
import com.github.sonus21.rqueue.listener.QueueDetail;

public class RqueueQueueMetrics {
    private final RqueueRedisTemplate<String> redisTemplate;

    public RqueueQueueMetrics(RqueueRedisTemplate<String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public long getPendingMessageCount(String queue) {
        try {
            QueueDetail queueDetail = EndpointRegistry.get(queue);
            return this.redisTemplate.getListSize(queueDetail.getQueueName());
        }
        catch (QueueDoesNotExist e) {
            return -1L;
        }
    }

    public long getScheduledMessageCount(String queue) {
        try {
            QueueDetail queueDetail = EndpointRegistry.get(queue);
            return this.redisTemplate.getZsetSize(queueDetail.getDelayedQueueName());
        }
        catch (QueueDoesNotExist e) {
            return -1L;
        }
    }

    public long getProcessingMessageCount(String queue) {
        try {
            QueueDetail queueDetail = EndpointRegistry.get(queue);
            return this.redisTemplate.getZsetSize(queueDetail.getProcessingQueueName());
        }
        catch (QueueDoesNotExist e) {
            return -1L;
        }
    }

    public long getPendingMessageCount(String queue, String priority) {
        try {
            QueueDetail queueDetail = EndpointRegistry.get(queue, priority);
            return this.redisTemplate.getListSize(queueDetail.getQueueName());
        }
        catch (QueueDoesNotExist e) {
            return -1L;
        }
    }

    public long getScheduledMessageCount(String queue, String priority) {
        try {
            QueueDetail queueDetail = EndpointRegistry.get(queue, priority);
            return this.redisTemplate.getZsetSize(queueDetail.getDelayedQueueName());
        }
        catch (QueueDoesNotExist e) {
            return -1L;
        }
    }

    public long getProcessingMessageCount(String queue, String priority) {
        try {
            QueueDetail queueDetail = EndpointRegistry.get(queue, priority);
            return this.redisTemplate.getZsetSize(queueDetail.getProcessingQueueName());
        }
        catch (QueueDoesNotExist e) {
            return -1L;
        }
    }
}

