/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.models.db;

import com.github.sonus21.rqueue.models.SerializableBase;
import com.github.sonus21.rqueue.models.aggregator.TasksStat;
import com.github.sonus21.rqueue.models.db.JobRunTime;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class QueueStatistics
extends SerializableBase {
    private static final long serialVersionUID = -4931206278693499365L;
    private String id;
    private Long startEpochDate;
    private Map<String, Long> tasksMovedToDeadLetter;
    private Map<String, Long> tasksDiscarded;
    private Map<String, Long> tasksSuccessful;
    private Map<String, Long> tasksRetried;
    private Map<String, JobRunTime> jobRunTime;
    private Long createdOn;
    private Long updatedOn;

    public QueueStatistics(String id) {
        this.id = id;
        this.updatedOn = this.createdOn = Long.valueOf(System.currentTimeMillis());
        this.tasksMovedToDeadLetter = new HashMap<String, Long>();
        this.tasksDiscarded = new HashMap<String, Long>();
        this.tasksSuccessful = new HashMap<String, Long>();
        this.tasksRetried = new HashMap<String, Long>();
        this.jobRunTime = new HashMap<String, JobRunTime>();
    }

    public void updateTime() {
        this.updatedOn = System.currentTimeMillis();
    }

    public void incrementDeadLetter(String date, long delta) {
        long val = this.tasksMovedToDeadLetter.getOrDefault(date, 0L);
        this.tasksMovedToDeadLetter.put(date, val + delta);
    }

    public void update(TasksStat stat, String eventDate) {
        if (stat.movedToDlq > 0L) {
            this.incrementDeadLetter(eventDate, stat.movedToDlq);
        }
        if (stat.discarded > 0L) {
            this.incrementDiscard(eventDate, stat.discarded);
        }
        if (stat.success > 0L) {
            this.incrementSuccessful(eventDate, stat.success);
        }
        if (stat.retried > 0L) {
            this.incrementRetry(eventDate, stat.retried);
        }
        this.updateJobExecutionTime(eventDate, stat.jobRunTime());
    }

    public void incrementDiscard(String date, long delta) {
        long val = this.tasksDiscarded.getOrDefault(date, 0L);
        this.tasksDiscarded.put(date, val + delta);
    }

    public void incrementSuccessful(String date, long delta) {
        long val = this.tasksSuccessful.getOrDefault(date, 0L);
        this.tasksSuccessful.put(date, val + delta);
    }

    public void updateJobExecutionTime(String date, JobRunTime jobRunTimeDelta) {
        JobRunTime val = this.jobRunTime.getOrDefault(date, null);
        if (val == null) {
            this.jobRunTime.put(date, jobRunTimeDelta);
        } else {
            val.setMax(Math.max(val.getMax(), jobRunTimeDelta.getMax()));
            val.setMin(Math.min(val.getMin(), jobRunTimeDelta.getMin()));
            val.setJobCount(val.getJobCount() + jobRunTimeDelta.getJobCount());
            val.setTotalExecutionTime(val.getTotalExecutionTime() + jobRunTimeDelta.getTotalExecutionTime());
            this.jobRunTime.put(date, val);
        }
    }

    private void cleanData(String date) {
        this.tasksMovedToDeadLetter.remove(date);
        this.tasksDiscarded.remove(date);
        this.tasksSuccessful.remove(date);
        this.tasksRetried.remove(date);
        this.jobRunTime.remove(date);
    }

    public void pruneStats(LocalDate date, int maxDays) {
        if (this.startEpochDate == null) {
            this.startEpochDate = date.toEpochDay();
            return;
        }
        long daysDifference = date.toEpochDay() - this.startEpochDate;
        long extraDaysData = daysDifference - (long)maxDays;
        if (extraDaysData > 0L) {
            LocalDate startDate = date.minusDays(maxDays);
            this.startEpochDate = startDate.toEpochDay();
            int i = 0;
            while ((long)i <= extraDaysData) {
                this.cleanData(startDate.minusDays(i).toString());
                ++i;
            }
        }
    }

    public void incrementRetry(String date, long delta) {
        long val = this.tasksRetried.getOrDefault(date, 0L);
        this.tasksRetried.put(date, val + delta);
    }

    public long tasksDiscarded(String date) {
        return this.tasksDiscarded.getOrDefault(date, 0L);
    }

    public long tasksSuccessful(String date) {
        return this.tasksSuccessful.getOrDefault(date, 0L);
    }

    public long tasksMovedToDeadLetter(String date) {
        return this.tasksMovedToDeadLetter.getOrDefault(date, 0L);
    }

    public long tasksRetried(String date) {
        return this.tasksRetried.getOrDefault(date, 0L);
    }

    public JobRunTime jobRunTime(String date) {
        return this.jobRunTime.getOrDefault(date, new JobRunTime());
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Long getStartEpochDate() {
        return this.startEpochDate;
    }

    @Generated
    public Map<String, Long> getTasksMovedToDeadLetter() {
        return this.tasksMovedToDeadLetter;
    }

    @Generated
    public Map<String, Long> getTasksDiscarded() {
        return this.tasksDiscarded;
    }

    @Generated
    public Map<String, Long> getTasksSuccessful() {
        return this.tasksSuccessful;
    }

    @Generated
    public Map<String, Long> getTasksRetried() {
        return this.tasksRetried;
    }

    @Generated
    public Map<String, JobRunTime> getJobRunTime() {
        return this.jobRunTime;
    }

    @Generated
    public Long getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public Long getUpdatedOn() {
        return this.updatedOn;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setStartEpochDate(Long startEpochDate) {
        this.startEpochDate = startEpochDate;
    }

    @Generated
    public void setTasksMovedToDeadLetter(Map<String, Long> tasksMovedToDeadLetter) {
        this.tasksMovedToDeadLetter = tasksMovedToDeadLetter;
    }

    @Generated
    public void setTasksDiscarded(Map<String, Long> tasksDiscarded) {
        this.tasksDiscarded = tasksDiscarded;
    }

    @Generated
    public void setTasksSuccessful(Map<String, Long> tasksSuccessful) {
        this.tasksSuccessful = tasksSuccessful;
    }

    @Generated
    public void setTasksRetried(Map<String, Long> tasksRetried) {
        this.tasksRetried = tasksRetried;
    }

    @Generated
    public void setJobRunTime(Map<String, JobRunTime> jobRunTime) {
        this.jobRunTime = jobRunTime;
    }

    @Generated
    public void setCreatedOn(Long createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public void setUpdatedOn(Long updatedOn) {
        this.updatedOn = updatedOn;
    }

    @Generated
    public QueueStatistics() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueStatistics)) {
            return false;
        }
        QueueStatistics other = (QueueStatistics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueueStatistics;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QueueStatistics(id=" + this.getId() + ", startEpochDate=" + this.getStartEpochDate() + ", tasksMovedToDeadLetter=" + this.getTasksMovedToDeadLetter() + ", tasksDiscarded=" + this.getTasksDiscarded() + ", tasksSuccessful=" + this.getTasksSuccessful() + ", tasksRetried=" + this.getTasksRetried() + ", jobRunTime=" + this.getJobRunTime() + ", createdOn=" + this.getCreatedOn() + ", updatedOn=" + this.getUpdatedOn() + ")";
    }
}

