/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.controller;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.utils.ReactiveEnabled;
import com.github.sonus21.rqueue.web.service.RqueueViewControllerService;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.reactive.result.view.ViewResolver;
import reactor.core.publisher.Mono;

@Controller
@RequestMapping(value={"rqueue"})
@Conditional(value={ReactiveEnabled.class})
public class ReactiveRqueueViewController {
    private final ViewResolver rqueueViewResolver;
    private final RqueueViewControllerService rqueueViewControllerService;
    private final RqueueWebConfig rqueueWebConfig;

    @Autowired
    public ReactiveRqueueViewController(RqueueConfig rqueueConfig, RqueueWebConfig rqueueWebConfig, RqueueViewControllerService rqueueViewControllerService, @Qualifier(value="reactiveRqueueViewResolver") ViewResolver rqueueViewResolver) {
        this.rqueueViewResolver = rqueueViewResolver;
        this.rqueueViewControllerService = rqueueViewControllerService;
        this.rqueueWebConfig = rqueueWebConfig;
    }

    private String xForwardedPrefix(ServerHttpRequest request) {
        return request.getHeaders().getFirst("x-forwarded-prefix");
    }

    @GetMapping
    public Mono<View> index(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
            return null;
        }
        this.rqueueViewControllerService.index(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("index", Locale.ENGLISH);
    }

    @GetMapping(value={"queues"})
    public Mono<View> queues(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
            return null;
        }
        this.rqueueViewControllerService.queues(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("queues", Locale.ENGLISH);
    }

    @GetMapping(value={"queues/{queueName}"})
    public Mono<View> queueDetail(@PathVariable String queueName, Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
            return null;
        }
        this.rqueueViewControllerService.queueDetail(model, this.xForwardedPrefix(request), queueName);
        return this.rqueueViewResolver.resolveViewName("queue_detail", Locale.ENGLISH);
    }

    @GetMapping(value={"running"})
    public Mono<View> running(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
            return null;
        }
        this.rqueueViewControllerService.running(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
    }

    @GetMapping(value={"scheduled"})
    public Mono<View> scheduled(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
            return null;
        }
        this.rqueueViewControllerService.scheduled(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
    }

    @GetMapping(value={"dead"})
    public Mono<View> dead(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
            return null;
        }
        this.rqueueViewControllerService.dead(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
    }

    @GetMapping(value={"pending"})
    public Mono<View> pending(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
            return null;
        }
        this.rqueueViewControllerService.pending(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
    }

    @GetMapping(value={"utility"})
    public Mono<View> utility(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
            return null;
        }
        this.rqueueViewControllerService.utility(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("utility", Locale.ENGLISH);
    }
}

