/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.service.impl;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.core.RqueueInternalPubSubChannel;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.impl.MessageSweeper;
import com.github.sonus21.rqueue.dao.RqueueStringDao;
import com.github.sonus21.rqueue.dao.RqueueSystemConfigDao;
import com.github.sonus21.rqueue.exception.UnknownSwitchCase;
import com.github.sonus21.rqueue.models.MessageMoveResult;
import com.github.sonus21.rqueue.models.db.QueueConfig;
import com.github.sonus21.rqueue.models.enums.DataType;
import com.github.sonus21.rqueue.models.request.MessageMoveRequest;
import com.github.sonus21.rqueue.models.request.PauseUnpauseQueueRequest;
import com.github.sonus21.rqueue.models.response.BaseResponse;
import com.github.sonus21.rqueue.models.response.BooleanResponse;
import com.github.sonus21.rqueue.models.response.MessageMoveResponse;
import com.github.sonus21.rqueue.models.response.StringResponse;
import com.github.sonus21.rqueue.utils.HttpUtils;
import com.github.sonus21.rqueue.utils.StringUtils;
import com.github.sonus21.rqueue.web.service.RqueueMessageMetadataService;
import com.github.sonus21.rqueue.web.service.RqueueUtilityService;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class RqueueUtilityServiceImpl
implements RqueueUtilityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueUtilityServiceImpl.class);
    private final RqueueWebConfig rqueueWebConfig;
    private final RqueueStringDao rqueueStringDao;
    private final RqueueSystemConfigDao rqueueSystemConfigDao;
    private final RqueueMessageTemplate rqueueMessageTemplate;
    private final RqueueMessageMetadataService messageMetadataService;
    private final RqueueInternalPubSubChannel rqueueInternalPubSubChannel;
    private final RqueueConfig rqueueConfig;
    private String latestVersion = "NA";
    private String releaseLink = "#";
    private long versionFetchTime = 0L;

    @Autowired
    public RqueueUtilityServiceImpl(RqueueConfig rqueueConfig, RqueueWebConfig rqueueWebConfig, RqueueStringDao rqueueStringDao, RqueueSystemConfigDao rqueueSystemConfigDao, RqueueMessageTemplate rqueueMessageTemplate, RqueueMessageMetadataService messageMetadataService, RqueueInternalPubSubChannel rqueueInternalPubSubChannel) {
        this.rqueueStringDao = rqueueStringDao;
        this.rqueueSystemConfigDao = rqueueSystemConfigDao;
        this.rqueueWebConfig = rqueueWebConfig;
        this.rqueueConfig = rqueueConfig;
        this.rqueueMessageTemplate = rqueueMessageTemplate;
        this.messageMetadataService = messageMetadataService;
        this.rqueueInternalPubSubChannel = rqueueInternalPubSubChannel;
    }

    @Override
    public BooleanResponse deleteMessage(String queueName, String id) {
        BooleanResponse booleanResponse = new BooleanResponse();
        QueueConfig queueConfig = this.rqueueSystemConfigDao.getConfigByName(queueName, true);
        if (queueConfig == null) {
            booleanResponse.setCode(1);
            booleanResponse.setMessage("Queue config not found!");
            return booleanResponse;
        }
        this.messageMetadataService.deleteMessage(queueName, id, Duration.ofDays(30L));
        booleanResponse.setValue(true);
        return booleanResponse;
    }

    private MessageMoveResponse moveMessageToZset(MessageMoveRequest messageMoveRequest) {
        String src = messageMoveRequest.getSrc();
        String dst = messageMoveRequest.getDst();
        int requestMessageCount = messageMoveRequest.getMessageCount(this.rqueueWebConfig);
        String newScore = (String)((Object)messageMoveRequest.getOthers().get("newScore"));
        Boolean isFixedScore = (Boolean)messageMoveRequest.getOthers().get("fixedScore");
        long scoreInMilli = 0L;
        boolean fixedScore = false;
        if (newScore != null) {
            scoreInMilli = Long.parseLong(newScore);
        }
        if (isFixedScore != null) {
            fixedScore = isFixedScore;
        }
        MessageMoveResult result = messageMoveRequest.getSrcType() == DataType.ZSET ? this.rqueueMessageTemplate.moveMessageZsetToZset(src, dst, requestMessageCount, scoreInMilli, fixedScore) : this.rqueueMessageTemplate.moveMessageListToZset(src, dst, requestMessageCount, scoreInMilli);
        MessageMoveResponse response = new MessageMoveResponse(result.getNumberOfMessages());
        response.setValue(result.isSuccess());
        return response;
    }

    private MessageMoveResponse moveMessageToList(MessageMoveRequest messageMoveRequest) {
        String src = messageMoveRequest.getSrc();
        String dst = messageMoveRequest.getDst();
        int requestMessageCount = messageMoveRequest.getMessageCount(this.rqueueWebConfig);
        MessageMoveResult result = messageMoveRequest.getSrcType() == DataType.ZSET ? this.rqueueMessageTemplate.moveMessageZsetToList(src, dst, requestMessageCount) : this.rqueueMessageTemplate.moveMessageListToList(src, dst, requestMessageCount);
        MessageMoveResponse response = new MessageMoveResponse(result.getNumberOfMessages());
        response.setValue(result.isSuccess());
        return response;
    }

    @Override
    public MessageMoveResponse moveMessage(MessageMoveRequest messageMoveRequest) {
        String message = messageMoveRequest.validationMessage();
        if (!StringUtils.isEmpty(message)) {
            MessageMoveResponse transferResponse = new MessageMoveResponse();
            transferResponse.setCode(1);
            transferResponse.setMessage(message);
            return transferResponse;
        }
        DataType dstType = messageMoveRequest.getDstType();
        switch (dstType) {
            case ZSET: {
                return this.moveMessageToZset(messageMoveRequest);
            }
            case LIST: {
                return this.moveMessageToList(messageMoveRequest);
            }
        }
        throw new UnknownSwitchCase(dstType.name());
    }

    @Override
    public BooleanResponse makeEmpty(String queueName, String dataName) {
        org.springframework.data.redis.connection.DataType type = this.rqueueStringDao.type(dataName);
        if (type == null || type == org.springframework.data.redis.connection.DataType.NONE) {
            return new BooleanResponse(true);
        }
        return new BooleanResponse(MessageSweeper.getInstance(this.rqueueConfig, this.rqueueMessageTemplate, this.messageMetadataService).deleteMessage(MessageSweeper.MessageDeleteRequest.builder().dataName(dataName).queueName(queueName).dataType(type).build()));
    }

    private boolean shouldFetchVersionDetail() {
        if (!this.rqueueConfig.isLatestVersionCheckEnabled()) {
            return false;
        }
        return System.currentTimeMillis() - this.versionFetchTime > 86400000L;
    }

    @Override
    public Pair<String, String> getLatestVersion() {
        String tagName;
        Map response;
        if (this.shouldFetchVersionDetail() && (response = (Map)HttpUtils.readUrl(this.rqueueConfig, "https://api.github.com/repos/sonus21/rqueue/releases/latest", LinkedHashMap.class)) != null && (tagName = (String)response.get("tag_name")) != null && !tagName.isEmpty() && Character.toLowerCase(tagName.charAt(0)) == 'v') {
            this.releaseLink = (String)response.get("html_url");
            this.latestVersion = tagName.substring(1);
            this.versionFetchTime = System.currentTimeMillis();
        }
        return Pair.of((Object)this.releaseLink, (Object)this.latestVersion);
    }

    @Override
    public StringResponse getDataType(String name) {
        return new StringResponse(DataType.convertDataType(this.rqueueStringDao.type(StringUtils.clean(name))).name());
    }

    @Override
    public Mono<BooleanResponse> makeEmptyReactive(String queueName, String datasetName) {
        return Mono.just((Object)this.makeEmpty(queueName, datasetName));
    }

    @Override
    public Mono<BooleanResponse> deleteReactiveMessage(String queueName, String messageId) {
        return Mono.just((Object)this.deleteMessage(queueName, messageId));
    }

    @Override
    public Mono<StringResponse> getReactiveDataType(String name) {
        return Mono.just((Object)this.getDataType(name));
    }

    @Override
    public Mono<MessageMoveResponse> moveReactiveMessage(MessageMoveRequest request) {
        return Mono.just((Object)this.moveMessage(request));
    }

    @Override
    public Mono<BaseResponse> reactivePauseUnpauseQueue(PauseUnpauseQueueRequest request) {
        return Mono.just((Object)this.pauseUnpauseQueue(request));
    }

    @Override
    public BaseResponse pauseUnpauseQueue(PauseUnpauseQueueRequest request) {
        log.info("Queue PauseUnpause request {}", (Object)request);
        QueueConfig queueConfig = this.rqueueSystemConfigDao.getConfigByName(request.getName(), true);
        BaseResponse response = new BaseResponse();
        if (queueConfig == null) {
            response.setMessage("Queue does not exist");
            response.setCode(404);
        } else {
            queueConfig.setPaused(!queueConfig.isPaused());
            this.rqueueInternalPubSubChannel.emitPauseUnpauseQueueEvent(request);
            this.rqueueInternalPubSubChannel.emitQueueConfigUpdateEvent(request);
            this.rqueueSystemConfigDao.saveQConfig(queueConfig);
        }
        return response;
    }
}

