/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.utils.QueueInfo;
import com.github.sonus21.rqueue.utils.RqueueRedisTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.script.DefaultScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.util.CollectionUtils;

public class RqueueMessageTemplate
extends RqueueRedisTemplate<RqueueMessage> {
    private Resource addMessage = new ClassPathResource("scripts/add-message.lua");
    private Resource removeMessage = new ClassPathResource("scripts/remove-message.lua");
    private Resource replaceMessage = new ClassPathResource("scripts/replace-message.lua");
    private RedisScript<Long> addScript = RedisScript.of((Resource)this.addMessage, Long.class);
    private RedisScript<Long> replaceMessageScript = RedisScript.of((Resource)this.replaceMessage, Long.class);
    private RedisScript<RqueueMessage> removeScript = RedisScript.of((Resource)this.removeMessage, RqueueMessage.class);
    private DefaultScriptExecutor<String> scriptExecutor = new DefaultScriptExecutor(this.redisTemplate);

    public RqueueMessageTemplate(RedisConnectionFactory redisConnectionFactory) {
        super(redisConnectionFactory);
    }

    public void add(String queueName, RqueueMessage message) {
        this.redisTemplate.opsForList().rightPush((Object)queueName, (Object)message);
    }

    public RqueueMessage pop(String queueName) {
        long currentTime = System.currentTimeMillis();
        return (RqueueMessage)this.scriptExecutor.execute(this.removeScript, Arrays.asList(queueName, QueueInfo.getProcessingQueueName(queueName), QueueInfo.getProcessingQueueChannelName(queueName)), new Object[]{currentTime, QueueInfo.getMessageReEnqueueTime(currentTime)});
    }

    public void addWithDelay(String queueName, RqueueMessage rqueueMessage) {
        this.scriptExecutor.execute(this.addScript, Arrays.asList(QueueInfo.getTimeQueueName(queueName), QueueInfo.getChannelName(queueName)), new Object[]{rqueueMessage, rqueueMessage.getProcessAt(), rqueueMessage.getQueuedTime()});
    }

    public void removeFromZset(String zsetName, RqueueMessage rqueueMessage) {
        this.redisTemplate.opsForZSet().remove((Object)zsetName, new Object[]{rqueueMessage});
    }

    public void replaceMessage(String zsetName, RqueueMessage src, RqueueMessage tgt) {
        this.scriptExecutor.execute(this.replaceMessageScript, Collections.singletonList(zsetName), new Object[]{src, tgt});
    }

    public List<RqueueMessage> getAllMessages(String queueName) {
        Set messagesInProcessingQueue;
        Set messagesFromZset;
        ArrayList<RqueueMessage> messages = this.redisTemplate.opsForList().range((Object)queueName, 0L, -1L);
        if (CollectionUtils.isEmpty((Collection)messages)) {
            messages = new ArrayList<RqueueMessage>();
        }
        if (!CollectionUtils.isEmpty((Collection)(messagesFromZset = this.redisTemplate.opsForZSet().range((Object)QueueInfo.getTimeQueueName(queueName), 0L, -1L)))) {
            messages.addAll(messagesFromZset);
        }
        if (!CollectionUtils.isEmpty((Collection)(messagesInProcessingQueue = this.redisTemplate.opsForZSet().range((Object)QueueInfo.getProcessingQueueName(queueName), 0L, -1L)))) {
            messages.addAll(messagesInProcessingQueue);
        }
        return messages;
    }
}

