/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.metrics;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class RqueueMetricsProperties {
    private final Map<String, String> tags = new LinkedHashMap<String, String>();
    private final Count count = new Count();
    private Tags metricTags = Tags.empty();

    public Count getCount() {
        return this.count;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Tags getMetricTags() {
        Tag tag = this.metricTags.stream().findFirst().orElse(null);
        if (tag == null && !this.tags.isEmpty()) {
            for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                this.metricTags = this.metricTags.and(entry.getKey(), entry.getValue());
            }
        }
        return this.metricTags;
    }

    public void setMetricTags(Tags tags) {
        this.metricTags = tags;
    }

    public boolean countExecution() {
        return this.count.isExecution();
    }

    public boolean countFailure() {
        return this.count.isFailure();
    }

    public static class Count {
        private boolean execution = false;
        private boolean failure = false;

        public boolean isExecution() {
            return this.execution;
        }

        public void setExecution(boolean execution) {
            this.execution = execution;
        }

        public boolean isFailure() {
            return this.failure;
        }

        public void setFailure(boolean failure) {
            this.failure = failure;
        }
    }
}

