/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import java.util.Collections;
import java.util.Map;

public abstract class QueueInfo {
    public static final String QUEUE_NAME = "QUEUE_NAME";
    private static final String DELAYED_QUEUE_PREFIX = "rqueue-delay::";
    private static final String CHANNEL_PREFIX = "rqueue-channel::";
    private static final String PROCESSING_PREFIX = "rqueue-processing::";
    private static final String PROCESSING_CHANNEL_PREFIX = "rqueue-processing-channel::";
    private static final long MAX_MESSAGE_PROCESSING_TIME = 900000L;

    public static Map<String, Object> getQueueHeaders(String queueName) {
        return Collections.singletonMap(QUEUE_NAME, queueName);
    }

    public static String getTimeQueueName(String queueName) {
        return DELAYED_QUEUE_PREFIX + queueName;
    }

    public static String getChannelName(String queueName) {
        return CHANNEL_PREFIX + queueName;
    }

    public static String getProcessingQueueName(String queueName) {
        return PROCESSING_PREFIX + queueName;
    }

    public static String getProcessingQueueChannelName(String queueName) {
        return PROCESSING_CHANNEL_PREFIX + queueName;
    }

    public static long getMessageReEnqueueTime() {
        return QueueInfo.getMessageReEnqueueTime(System.currentTimeMillis());
    }

    public static long getMessageReEnqueueTime(long currentTime) {
        return currentTime + 900000L;
    }
}

