package com.github;

import com.github.structlogging.LoggingEvent;
import java.lang.String;

public class BlockRemoval extends LoggingEvent {
  private final long blockId;

  private final long dataNodeUuid;

  private final int numCached;

  private final int neededCached;

  public BlockRemoval(final String message, final String sourceFile, final long lineNumber, final String type, final long sid, final String logLevel, final long timestamp, final long blockId, final long dataNodeUuid, final int numCached, final int neededCached) {
    super(message,sourceFile,lineNumber,type,sid,logLevel,timestamp);this.blockId=blockId;this.dataNodeUuid=dataNodeUuid;this.numCached=numCached;this.neededCached=neededCached;}

  public long getBlockId() {
    return this.blockId;}

  public long getDataNodeUuid() {
    return this.dataNodeUuid;}

  public int getNumCached() {
    return this.numCached;}

  public int getNeededCached() {
    return this.neededCached;}
}
