/*
 * Decompiled with CFR 0.152.
 */
package com.github.sundev79.MineBootFramework.MineBootShell;

import com.github.sundev79.MineBootFramework.MineBootShell.builtin.MineBootShellCommandType;
import com.github.sundev79.MineBootFramework.MineBootframework.api.events.MineBootEventHandler;
import java.util.ArrayList;
import java.util.HashMap;

public class MineBootCommand {
    private String commandName;
    private String commandDetails;
    private static final HashMap<String, MineBootCommand> commandsMap = new HashMap();
    private MineBootEventHandler eventHandler;
    private MineBootShellCommandType commandType;
    private ArrayList<String> commandArgs = new ArrayList();

    public MineBootCommand(String cmdName, MineBootShellCommandType cmdType) {
        this.commandName = cmdName;
        this.commandType = cmdType;
    }

    public void launchCommand() {
        this.eventHandler.onEvent();
        if (!this.getCommandArgs().isEmpty()) {
            this.getCommandArgs().clear();
        }
    }

    public String getCommandDetails() {
        if (this.commandDetails == null || this.commandDetails.isEmpty()) {
            this.commandDetails = "No Details provided.";
        }
        return this.commandDetails;
    }

    public void setCommandArgs(ArrayList<String> args) {
        this.commandArgs = args;
    }

    public ArrayList<String> getCommandArgs() {
        return this.commandArgs;
    }

    public void setCommandDetails(String details) {
        this.commandDetails = details;
    }

    public static void unregisterCommand(MineBootCommand command) {
        MineBootCommand.getCommands().remove(command.getCommandName());
    }

    public static void unregisterAllCommands() {
        System.out.println("Unregistering All Commands ...");
        MineBootCommand.getCommands().clear();
        System.out.println("...done !");
    }

    public static void registerCommand(MineBootCommand command) {
        MineBootCommand.getCommands().put(command.getCommandName(), command);
    }

    public static HashMap<String, MineBootCommand> getCommands() {
        return commandsMap;
    }

    public MineBootEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(MineBootEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public MineBootShellCommandType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(MineBootShellCommandType commandType) {
        this.commandType = commandType;
    }
}

