/*
 * Decompiled with CFR 0.152.
 */
package com.github.taomus.mytools.lang;

import com.github.taomus.mytools.exception.CodeRuntimeException;
import com.github.taomus.mytools.exception.UnrealizedException;
import com.github.taomus.mytools.utils.CodeRuntimeClassLoader;
import com.github.taomus.mytools.utils.CommonUtils;
import com.github.taomus.mytools.utils.asm.AsmUtils;
import com.github.taomus.mytools.utils.asm.CreateClass;
import java.io.EOFException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Tuple {
    private Class<?> tupleClass;
    private Object tupleInstance;
    private static final ConcurrentMap<String, String> CACHE = new ConcurrentHashMap<String, String>();
    private long length = 0L;

    public Tuple() {
        Thread.currentThread().setContextClassLoader(CodeRuntimeClassLoader.getInstace());
    }

    public Tuple(Object arg0, Object ... args) throws CodeRuntimeException {
        this();
        ArrayList<String> types = new ArrayList<String>();
        types.add(arg0.getClass().getSimpleName());
        for (int i = 0; i < args.length; ++i) {
            types.add(args[i].getClass().getSimpleName());
        }
        String key = StringUtils.join(types, (String)",");
        this.create(key, arg0, args);
    }

    private void create(String key, Object arg0, Object ... args) throws CodeRuntimeException {
        try {
            if (!CACHE.containsKey(key)) {
                String name = String.format("Tuple%s", UUID.randomUUID().toString().replace("-", ""));
                AsmUtils autils = new AsmUtils(CommonUtils.isDedug);
                CreateClass cc = autils.createClass(name);
                cc.createPrivateField("arg0", arg0.getClass());
                this.length = 1L;
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    cc.createPrivateField(String.format("arg%d", i + 1), arg.getClass());
                }
                this.length += (long)args.length;
                this.tupleInstance = autils.newInstance();
                CACHE.put(key, name);
            } else {
                this.tupleInstance = Class.forName((String)CACHE.get(key), false, CodeRuntimeClassLoader.getInstace()).newInstance();
                this.length = args.length + 1;
            }
            this.tupleClass = this.tupleInstance.getClass();
            this.set(0, arg0);
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                this.set(i + 1, arg);
            }
        }
        catch (ArrayIndexOutOfBoundsException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new CodeRuntimeException(e);
        }
    }

    public long length() {
        return this.length;
    }

    public List<String> getType() {
        ArrayList<String> types = new ArrayList<String>();
        int i = 0;
        while ((long)i < this.length) {
            types.add(this.get(i).getClass().getSimpleName());
            ++i;
        }
        return types;
    }

    public String toString() {
        ArrayList<Object> objlist = new ArrayList<Object>();
        int i = 0;
        while ((long)i < this.length) {
            Object value = this.get(i);
            if (value instanceof String) {
                objlist.add(String.format("\"%s\"", this.get(i)));
            } else {
                objlist.add(this.get(i));
            }
            ++i;
        }
        return String.format("(%s)", StringUtils.join((Object[])objlist.toArray(), (String)","));
    }

    public static Tuple fromString(String value) throws EOFException, CodeRuntimeException {
        Stack<Object> tempStack = new Stack<Object>();
        String[] values = value.split("");
        for (int i = 0; i < values.length; ++i) {
            Object[] templ;
            Vector<Object> l;
            Object oval;
            StringBuffer temp;
            String val = values[i];
            if (val.equals("(")) {
                tempStack.push("(");
                continue;
            }
            if (val.equals("[")) {
                tempStack.push("[");
                continue;
            }
            if (Character.isDigit(val.charAt(0))) {
                temp = new StringBuffer(val);
                while (!(i + 1 >= values.length || values[i + 1].equals(",") || values[i + 1].equals(")") || values[i + 1].equals("]"))) {
                    temp.append(values[++i]);
                }
                String newVal = temp.toString();
                if (newVal.contains(".")) {
                    tempStack.push(Double.parseDouble(newVal));
                    continue;
                }
                tempStack.push(Integer.parseInt(newVal));
                continue;
            }
            if (val.equals("\"")) {
                temp = new StringBuffer();
                while (i + 1 < values.length && !values[i + 1].equals("\"")) {
                    temp.append(values[++i]);
                }
                if (values[++i].equals(",")) {
                    ++i;
                }
                tempStack.push(temp.toString().length() > 1 ? temp.toString() : Character.valueOf(temp.toString().charAt(0)));
                continue;
            }
            if (values[i].equals("]")) {
                oval = tempStack.pop();
                l = new Vector<Object>();
                while (true) {
                    if (oval instanceof String) {
                        if (oval.equals("[")) break;
                        l.add(oval);
                    } else {
                        l.add(oval);
                    }
                    oval = tempStack.pop();
                }
                templ = l.toArray();
                ArrayUtils.reverse((Object[])templ);
                l.clear();
                for (Object o : templ) {
                    l.add(o);
                }
                tempStack.push(l);
                continue;
            }
            if (!values[i].equals(")")) continue;
            oval = tempStack.pop();
            l = new Vector();
            while (true) {
                if (oval instanceof String) {
                    if (oval.equals("(")) break;
                    l.add(oval);
                } else {
                    l.add(oval);
                }
                oval = tempStack.pop();
            }
            templ = l.toArray();
            ArrayUtils.reverse((Object[])templ);
            l.clear();
            for (Object o : templ) {
                l.add(o);
            }
            tempStack.push(Tuple.fromTuple(l));
        }
        if (tempStack.size() > 1) {
            throw new EOFException("\u683c\u5f0f\u9519\u8bef: " + tempStack.toString());
        }
        return (Tuple)tempStack.pop();
    }

    public List<Object> toList() {
        Vector<Object> values = new Vector<Object>();
        int j = 0;
        while ((long)j < this.length) {
            values.add(this.get(j));
            ++j;
        }
        return values;
    }

    public static Tuple fromTuple(List<Object> data) throws CodeRuntimeException {
        if (data != null && data.size() > 0) {
            Object arg0 = data.get(0);
            data.remove(0);
            if (data.size() > 0) {
                Object[] args = data.toArray();
                return new Tuple(arg0, args);
            }
            return new Tuple(arg0, new Object[0]);
        }
        return null;
    }

    public <T> T get(Class<T> zlass) throws ArrayIndexOutOfBoundsException, InstantiationException, IllegalAccessException {
        Field[] fiels = zlass.getDeclaredFields();
        T dest = zlass.newInstance();
        for (int j = 0; j < fiels.length; ++j) {
            Field f = fiels[j];
            f.setAccessible(true);
            Object value = this.get(j);
            f.set(dest, value);
        }
        return dest;
    }

    public Object get(String name) throws UnrealizedException {
        throw new UnrealizedException("function unrealized");
    }

    public Tuple build(Object arg0, Object ... args) throws Exception {
        throw new Exception();
    }

    public Object get(int i) throws ArrayIndexOutOfBoundsException {
        if ((long)i > this.length) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        try {
            return this.tupleClass.getMethod(String.format("getArg%d", i), new Class[0]).invoke(this.tupleInstance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void set(int i, Object value) throws ArrayIndexOutOfBoundsException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if ((long)i > this.length) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        this.tupleClass.getMethod(String.format("setArg%d", i), value.getClass()).invoke(this.tupleInstance, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (this.tupleClass == null ? 0 : this.tupleClass.hashCode());
        result = 31 * result + (this.tupleInstance == null ? 0 : this.tupleInstance.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        if (this.length != other.length) {
            return false;
        }
        if (this.tupleClass == null ? other.tupleClass != null : !this.tupleClass.equals(other.tupleClass)) {
            return false;
        }
        return !(this.tupleInstance == null ? other.tupleInstance != null : !this.tupleInstance.equals(other.tupleInstance));
    }
}

