/*
 * Decompiled with CFR 0.152.
 */
package com.github.taomus.mytools.utils.asm;

import com.github.taomus.mytools.utils.CodeRuntimeClassLoader;
import com.github.taomus.mytools.utils.asm.CreateClass;
import com.github.taomus.org.objectweb.asm.ClassWriter;
import com.github.taomus.org.objectweb.asm.util.TraceClassVisitor;
import java.io.PrintWriter;

public class AsmUtils {
    private ClassWriter cwriter = new ClassWriter(1);
    private TraceClassVisitor tcvisitor;
    private String zlassName;

    public AsmUtils() {
        this(false);
    }

    public AsmUtils(boolean isDebug) {
        PrintWriter pw = null;
        if (isDebug) {
            pw = new PrintWriter(System.err);
        }
        this.tcvisitor = new TraceClassVisitor(this.cwriter, pw);
    }

    public CreateClass createClass(String name) {
        return this.createClass(name, null);
    }

    public CreateClass createClass(String name, String[] interfaces) {
        this.zlassName = name;
        return new CreateClass(this.tcvisitor, name, interfaces);
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.tcvisitor.visitEnd();
        byte[] bytes = this.cwriter.toByteArray();
        CodeRuntimeClassLoader.set(this.zlassName, bytes);
        Thread.currentThread().setContextClassLoader(CodeRuntimeClassLoader.getInstace());
        return Thread.currentThread().getContextClassLoader().loadClass(this.zlassName).newInstance();
    }
}

