/*
 * Decompiled with CFR 0.152.
 */
package com.github.taomus.mytools.utils.asm;

import com.github.taomus.mytools.utils.CommonUtils;
import com.github.taomus.mytools.utils.asm.CreateFunction;
import com.github.taomus.org.objectweb.asm.Type;
import com.github.taomus.org.objectweb.asm.commons.GeneratorAdapter;
import com.github.taomus.org.objectweb.asm.commons.Method;
import com.github.taomus.org.objectweb.asm.util.TraceClassVisitor;
import java.util.HashMap;

public class CreateClass
extends CreateFunction {
    GeneratorAdapter ga = null;

    public CreateClass(TraceClassVisitor tcvisitor, String name) {
        this(tcvisitor, name, null);
    }

    public CreateClass(TraceClassVisitor tcvisitor, String name, String[] interfaces) {
        this.tcvisitor = tcvisitor;
        this.createConstructor(name, interfaces);
        this.className = name;
    }

    private void createConstructor(String name, String[] interfaces) {
        this.createConstructor(name, "java/lang/Object", interfaces);
    }

    private void createConstructor(String name, String superName, String[] interfaces) {
        this.fieldVeriable = new HashMap();
        this.tcvisitor.visit(52, 1, name, null, superName, interfaces);
        Method m = Method.getMethod("void <init>()");
        GeneratorAdapter ga = new GeneratorAdapter(1, m, null, null, this.tcvisitor);
        ga.loadThis();
        ga.invokeConstructor(Type.getType(Object.class), m);
        ga.returnValue();
        ga.endMethod();
    }

    public void createSerialVersionUID() {
        this.tcvisitor.visitField(26, "serialVersionUID", Type.getType(Long.TYPE).getDescriptor(), null, 1L).visitEnd();
    }

    public void createPrivateField(String name, Class<?> zlass) {
        this.createField(2, name, zlass, null, true);
    }

    public void createPrivateFinalField(String name, Class<?> zlass, Object value) {
        this.createField(18, name, zlass, value, true);
    }

    public void createField(int access, String name, Class<?> zlass, Object value, boolean isGetSet) {
        this.tcvisitor.visitField(access, name, Type.getType(zlass).getDescriptor(), null, value).visitEnd();
        this.fieldVeriable.put(name, zlass);
        if (isGetSet) {
            String fName = CommonUtils.camelUpperName(name);
            String ftype = zlass.getTypeName();
            GeneratorAdapter ga = new GeneratorAdapter(1, Method.getMethod(ftype + " get" + fName + "()", true), null, null, this.tcvisitor);
            ga.loadThis();
            ga.getField(Type.getType(this.className), name, Type.getType(zlass));
            if (ftype.endsWith("[]")) {
                ga.invokeVirtual(Type.getType(zlass), Method.getMethod("Object clone()"));
                ga.checkCast(Type.getType(zlass));
            }
            ga.returnValue();
            ga.endMethod();
            ga = new GeneratorAdapter(1, Method.getMethod("void set" + fName + "(" + ftype + ")", true), null, null, this.tcvisitor);
            ga.loadThis();
            ga.loadArg(0);
            ga.putField(Type.getType(this.className), name, Type.getType(zlass));
            ga.returnValue();
            ga.endMethod();
        }
    }

    public void createPublieField(String name, Class<?> zlass) {
        this.createField(1, name, zlass, null, false);
    }

    public void createProtectedField(String name, Class<?> zlass, boolean isGetSet) {
        this.createField(4, name, zlass, null, isGetSet);
    }
}

