/*
 * Decompiled with CFR 0.152.
 */
package com.github.taomus.mytools.utils.asm;

import com.github.taomus.mytools.utils.asm.ICode;
import com.github.taomus.org.objectweb.asm.Type;
import com.github.taomus.org.objectweb.asm.commons.GeneratorAdapter;
import com.github.taomus.org.objectweb.asm.commons.Method;
import com.github.taomus.org.objectweb.asm.util.TraceClassVisitor;
import java.util.HashMap;
import java.util.Map;

public class CreateFunction {
    private GeneratorAdapter ga;
    private Integer localStoreNumber = 0;
    private Map<String, Integer> localStoreVeriable = null;
    protected TraceClassVisitor tcvisitor = null;
    protected Map<String, Class<?>> fieldVeriable = null;
    protected String className;

    public CreateFunction FuncBegin(String method, int defaultScope) {
        this.localStoreVeriable = new HashMap<String, Integer>();
        this.ga = new GeneratorAdapter(defaultScope, Method.getMethod(method), null, null, this.tcvisitor);
        return this;
    }

    public CreateFunction FuncPublicBegin(String method) {
        return this.FuncBegin(method, 1);
    }

    public CreateFunction FuncStaticBegin(String method) {
        return this.FuncBegin(method, 9);
    }

    public CreateFunction FuncPrivateBegin(String method) {
        return this.FuncBegin(method, 2);
    }

    public CreateFunction FuncProtectedBegin(String method) {
        return this.FuncBegin(method, 4);
    }

    public CreateFunction getLocalStore(String key, Class<?> zlass) {
        Integer index = this.localStoreVeriable.get(key);
        this.ga.loadLocal(index, Type.getType(zlass));
        return this;
    }

    public <T> CreateFunction setLocalStore(String key, Class<T> zlass, T val) {
        CreateFunction createFunction = this;
        Integer index = createFunction.localStoreNumber = Integer.valueOf(createFunction.localStoreNumber + 1);
        this.localStoreVeriable.put(key, index);
        this.storeValue(zlass, val);
        this.ga.storeLocal(index, Type.getType(zlass));
        return this;
    }

    public CreateFunction invoke(String method) {
        this.ga.loadThis();
        this.ga.invokeVirtual(Type.getType(this.className), Method.getMethod(method));
        return this;
    }

    public <T> CreateFunction argsToThis(int index, String thisName, Class<T> zlass) {
        this.ga.loadThis();
        this.ga.loadArg(index);
        if (this.fieldVeriable.containsKey(thisName) && this.fieldVeriable.get(thisName).equals(zlass)) {
            this.ga.putField(Type.getType(this.className), thisName, Type.getType(zlass));
        } else {
            this.tcvisitor.visitField(4, thisName, Type.getType(zlass).getDescriptor(), null, null).visitEnd();
            this.fieldVeriable.put(thisName, zlass);
            this.ga.putField(Type.getType(this.className), thisName, Type.getType(zlass));
        }
        return this;
    }

    public <T> CreateFunction setThis(String name, Class<T> zlass, T val) {
        this.ga.loadThis();
        this.storeValue(zlass, val);
        if (this.fieldVeriable.containsKey(name) && this.fieldVeriable.get(name).equals(zlass)) {
            this.ga.putField(Type.getType(this.className), name, Type.getType(zlass));
        } else {
            this.tcvisitor.visitField(4, name, Type.getType(zlass).getDescriptor(), null, null).visitEnd();
            this.fieldVeriable.put(name, zlass);
            this.ga.putField(Type.getType(this.className), name, Type.getType(zlass));
        }
        return this;
    }

    public CreateFunction getThis(String name) {
        this.ga.loadThis();
        Class<?> zlass = this.fieldVeriable.get(name);
        this.ga.getField(Type.getType(this.className), name, Type.getType(zlass));
        return this;
    }

    private <T> void storeValue(Class<T> zlass, T val) {
        if (zlass.equals(Integer.TYPE)) {
            this.ga.push((Integer)val);
        } else if (zlass.equals(Long.TYPE)) {
            this.ga.push((Long)val);
        } else if (zlass.equals(Character.TYPE)) {
            this.ga.push(((Character)val).charValue());
        } else if (zlass.equals(Double.TYPE)) {
            this.ga.push((Double)val);
        } else if (zlass.equals(Float.TYPE)) {
            this.ga.push(((Float)val).floatValue());
        } else if (zlass.equals(Boolean.TYPE)) {
            this.ga.push((Boolean)val);
        } else if (zlass.equals(String.class)) {
            this.ga.push((String)val);
        }
    }

    public CreateFunction appendCode(ICode code) {
        code.code(this.ga);
        return this;
    }

    public void FuncEnd() {
        this.ga.returnValue();
        this.ga.endMethod();
    }
}

