/*
 * Decompiled with CFR 0.152.
 */
package com.github.taomus.org.objectweb.asm.optimizer;

import com.github.taomus.org.objectweb.asm.AnnotationVisitor;
import com.github.taomus.org.objectweb.asm.Attribute;
import com.github.taomus.org.objectweb.asm.FieldVisitor;
import com.github.taomus.org.objectweb.asm.TypePath;
import com.github.taomus.org.objectweb.asm.optimizer.AnnotationConstantsCollector;
import com.github.taomus.org.objectweb.asm.optimizer.ConstantPool;

public class FieldConstantsCollector
extends FieldVisitor {
    private final ConstantPool cp;

    public FieldConstantsCollector(FieldVisitor fv, ConstantPool cp) {
        super(327680, fv);
        this.cp = cp;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleAnnotations");
        }
        return new AnnotationConstantsCollector(this.fv.visitAnnotation(desc, visible), this.cp);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleTypeAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleTypeAnnotations");
        }
        return new AnnotationConstantsCollector(this.fv.visitAnnotation(desc, visible), this.cp);
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.fv.visitAttribute(attr);
    }

    @Override
    public void visitEnd() {
        this.fv.visitEnd();
    }
}

