/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.deps;

import cdc.deps.DAnalysis;
import cdc.deps.DAnalysisDebug;
import cdc.deps.DElement;
import cdc.deps.DElementKind;
import cdc.deps.DElementScope;
import cdc.deps.java.DJavaAnalysis;
import cdc.deps.java.DJavaAnalyzer;
import cdc.deps.java.asm.AsmJavaAnalyzer;
import java.io.File;
import java.io.PrintStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsmJavaAnalyzerTest {
    private static final Logger LOGGER = LogManager.getLogger(AsmJavaAnalyzerTest.class);
    private static final PrintStream OUT = IoBuilder.forLogger((Logger)LOGGER).setLevel(Level.DEBUG).buildPrintStream();
    private static final File TARGET = new File("./target");
    private static final File TEST_CLASSES = new File(TARGET, "test-classes");

    @Test
    public void testAAnalysis() throws Exception {
        AsmJavaAnalyzer analyzer = new AsmJavaAnalyzer();
        analyzer.setEnabled(DJavaAnalyzer.Feature.IGNORE_JDK_TYPES, true);
        DJavaAnalysis analysis = analyzer.getAnalysis();
        analyzer.analyzeClassFile(new File(TEST_CLASSES, "cdc/test/deps/p1/A.class"));
        analyzer.postAnalysis();
        DAnalysisDebug.print((DAnalysis)analysis, (PrintStream)OUT);
        DElement element = analysis.getElement("cdc");
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)DElementKind.PACKAGE, (Object)element.getKind());
        Assertions.assertEquals((Object)DElementScope.UNKNOWN, (Object)element.getScope());
        Assertions.assertEquals((Object)"Java.Package", (Object)element.getCategory());
        element = analysis.getElement("cdc/test");
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)DElementKind.PACKAGE, (Object)element.getKind());
        Assertions.assertEquals((Object)DElementScope.UNKNOWN, (Object)element.getScope());
        Assertions.assertEquals((Object)"Java.Package", (Object)element.getCategory());
        element = analysis.getElement("cdc/test/deps");
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)DElementKind.PACKAGE, (Object)element.getKind());
        Assertions.assertEquals((Object)DElementScope.UNKNOWN, (Object)element.getScope());
        Assertions.assertEquals((Object)"Java.Package", (Object)element.getCategory());
        element = analysis.getElement("cdc/test/deps/p1");
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)DElementKind.PACKAGE, (Object)element.getKind());
        Assertions.assertEquals((Object)DElementScope.MIXED, (Object)element.getScope());
        Assertions.assertEquals((Object)"Java.Package", (Object)element.getCategory());
        element = analysis.getElement("cdc/test/deps/p1/A");
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)DElementKind.ITEM, (Object)element.getKind());
        Assertions.assertEquals((Object)DElementScope.INTERNAL, (Object)element.getScope());
        Assertions.assertEquals((Object)"Java.Class", (Object)element.getCategory());
        Assertions.assertTrue((boolean)element.getFeatures().contains("PUBLIC"));
        element = analysis.getElement("cdc/test/deps/p1/A$StaticNested1");
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)DElementKind.ITEM, (Object)element.getKind());
        Assertions.assertEquals((Object)DElementScope.MIXED, (Object)element.getScope());
        Assertions.assertEquals((Object)"Java.Class", (Object)element.getCategory());
        Assertions.assertTrue((boolean)element.getFeatures().contains("NESTED"));
        Assertions.assertTrue((boolean)element.getFeatures().contains("PUBLIC"));
        Assertions.assertTrue((boolean)element.getFeatures().contains("STATIC"));
        analyzer.analyzeClassFile(new File(TEST_CLASSES, "cdc/test/deps/p1/A$StaticNested1.class"));
        analyzer.postAnalysis();
        DAnalysisDebug.print((DAnalysis)analyzer.getAnalysis(), (PrintStream)OUT);
        element = analysis.getElement("cdc/test/deps/p1/A$StaticNested1");
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)DElementKind.ITEM, (Object)element.getKind());
        Assertions.assertEquals((Object)DElementScope.INTERNAL, (Object)element.getScope());
        Assertions.assertEquals((Object)"Java.Class", (Object)element.getCategory());
        Assertions.assertTrue((boolean)element.getFeatures().contains("NESTED"));
        Assertions.assertTrue((boolean)element.getFeatures().contains("PUBLIC"));
        Assertions.assertTrue((boolean)element.getFeatures().contains("STATIC"));
    }

    @Test
    public void testCAnalysis() throws Exception {
        AsmJavaAnalyzer analyzer = new AsmJavaAnalyzer();
        DJavaAnalysis analysis = analyzer.getAnalysis();
        analyzer.setEnabled(DJavaAnalyzer.Feature.IGNORE_JDK_TYPES, true);
        analyzer.analyzeClassFile(new File(TEST_CLASSES, "cdc/test/deps/p1/C.class"));
        analyzer.postAnalysis();
        DAnalysisDebug.print((DAnalysis)analysis, (PrintStream)OUT);
        DElement element = analysis.getElement("cdc");
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)DElementKind.PACKAGE, (Object)element.getKind());
        Assertions.assertEquals((Object)DElementScope.UNKNOWN, (Object)element.getScope());
        Assertions.assertEquals((Object)"Java.Package", (Object)element.getCategory());
        element = analysis.getElement("cdc/test");
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)DElementKind.PACKAGE, (Object)element.getKind());
        Assertions.assertEquals((Object)DElementScope.UNKNOWN, (Object)element.getScope());
        Assertions.assertEquals((Object)"Java.Package", (Object)element.getCategory());
        element = analysis.getElement("cdc/test/deps");
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)DElementKind.PACKAGE, (Object)element.getKind());
        Assertions.assertEquals((Object)DElementScope.UNKNOWN, (Object)element.getScope());
        Assertions.assertEquals((Object)"Java.Package", (Object)element.getCategory());
        element = analysis.getElement("cdc/test/deps/p1");
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)DElementKind.PACKAGE, (Object)element.getKind());
        Assertions.assertEquals((Object)DElementScope.MIXED, (Object)element.getScope());
        Assertions.assertEquals((Object)"Java.Package", (Object)element.getCategory());
        element = analysis.getElement("cdc/test/deps/p1/C");
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)DElementKind.ITEM, (Object)element.getKind());
        Assertions.assertEquals((Object)DElementScope.INTERNAL, (Object)element.getScope());
        Assertions.assertEquals((Object)"Java.Class", (Object)element.getCategory());
        Assertions.assertTrue((boolean)element.getFeatures().contains("PUBLIC"));
        element = analysis.getElement("cdc/test/deps/p1/CLocal");
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)DElementKind.ITEM, (Object)element.getKind());
        Assertions.assertEquals((Object)DElementScope.EXTERNAL, (Object)element.getScope());
        Assertions.assertEquals((Object)"Java.Unknown", (Object)element.getCategory());
    }
}

