/*
 * Decompiled with CFR 0.152.
 */
package cdc.deps.java;

import cdc.deps.DAnalysis;
import cdc.deps.DElement;
import cdc.deps.DElementKind;
import cdc.deps.DElementScope;
import cdc.deps.DGroup;
import cdc.deps.DItem;
import cdc.deps.DNamespace;
import cdc.deps.DPackage;
import cdc.util.files.Files;
import cdc.util.strings.StringRecognizer;
import java.io.File;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DJavaAnalysis
extends DAnalysis {
    private static final Logger LOGGER = LogManager.getLogger(DJavaAnalysis.class);
    private static final char PACKAGE_SEPARATOR = '/';
    private static final char CLASS_SEPARATOR = '$';
    public static final String CATEGORY_UNKNOWN = "Java.Unknown";
    public static final String CATEGORY_CLASS = "Java.Class";
    public static final String CATEGORY_INTERFACE = "Java.Interface";
    public static final String CATEGORY_ENUM = "Java.Enum";
    public static final String CATEGORY_CLASS_FILE = "Java.ClassFile";
    public static final String CATEGORY_JAR = "Java.Archive";
    public static final String CATEGORY_FOLDER = "Java.Folder";
    public static final String CATEGORY_PACKAGE = "Java.Package";
    public static final String FEATURE_ABSTRACT = "ABSTRACT";
    public static final String FEATURE_PUBLIC = "PUBLIC";
    public static final String FEATURE_PROTECTED = "PROTECTED";
    public static final String FEATURE_PRIVATE = "PRIVATE";
    public static final String FEATURE_PACKAGE = "PACKAGE";
    public static final String FEATURE_STATIC = "STATIC";
    public static final String FEATURE_FINAL = "FINAL";
    public static final String FEATURE_NESTED = "NESTED";
    public static final String FEATURE_ANONYMOUS = "ANONYMOUS";
    public static final String FEATURE_DEPRECATED = "DEPRECATED";
    public static final String FEATURE_GENERIC = "GENERIC";
    private static final Predicate<DElement> IS_ANONYMOUS_CLASS = value -> value.getKind() == DElementKind.ITEM && value.isEnabled(FEATURE_ANONYMOUS);
    private static final Predicate<DElement> IS_HIDDEN_TYPE = value -> value.getKind() == DElementKind.ITEM && (value.isEnabled(FEATURE_ANONYMOUS) || value.isEnabled(FEATURE_NESTED) && value.isEnabled(FEATURE_PRIVATE));
    private static final Predicate<DElement> IS_TYPE = value -> value.getKind() == DElementKind.ITEM;

    public DGroup findOrCreateGroup(DGroup refGroup, File relativePath) {
        LOGGER.trace("createOrFindGroup(" + refGroup + ", " + relativePath + ")");
        File relativeParent = relativePath.getParentFile();
        DGroup parentGroup = relativeParent == null ? refGroup : this.findOrCreateGroup(refGroup, relativeParent);
        File tmp = new File(parentGroup.getName(), relativePath.getName());
        return this.findOrCreateGroup(Files.normalize((String)tmp.getPath()), parentGroup);
    }

    public DPackage findOrCreatePackage(String name, boolean hasClass) {
        LOGGER.trace("createOrFindPackage(" + name + ", " + hasClass + ")");
        if (hasClass) {
            int pos = name.lastIndexOf(47);
            if (pos >= 0) {
                return this.findOrCreatePackage(name.substring(0, pos));
            }
            return this.findOrCreatePackage("");
        }
        return this.findOrCreatePackage(name);
    }

    public DItem findOrCreateItem(String name, DGroup group) {
        LOGGER.trace("createOrFindItem(" + name + ", " + group + ")");
        DItem result = this.getItem(name);
        if (result == null) {
            int pos = name.lastIndexOf(36);
            if (pos >= 0) {
                DItem parent = this.findOrCreateItem(name.substring(0, pos), null);
                result = this.createItem(name, group, (DNamespace)parent);
                result.setEnabled(FEATURE_NESTED, true);
                result.setCategory(CATEGORY_UNKNOWN);
                if (parent.getScope() == DElementScope.INTERNAL) {
                    result.setScope(DElementScope.MIXED);
                } else {
                    result.setScope(parent.getScope());
                }
            } else {
                DPackage parent = this.findOrCreatePackage(name, true);
                result = this.createItem(name, group, (DNamespace)parent);
                result.setCategory(CATEGORY_UNKNOWN);
                result.setScope(DElementScope.EXTERNAL);
            }
        } else if (group != null) {
            if (result.getOwner() == null) {
                result.setGroup(group);
            } else {
                LOGGER.error(result + " is already attached to group " + result.getOwner());
                LOGGER.error("   Can not set it to " + group);
                LOGGER.error("   Do not specify the same group twice.");
            }
        }
        return result;
    }

    private DPackage findOrCreatePackage(String name) {
        LOGGER.trace("createOrFindPackage(" + name + ")");
        DPackage result = this.getPackage(name);
        if (result == null) {
            int pos = name.lastIndexOf(47);
            if (pos >= 0) {
                DPackage parent = this.findOrCreatePackage(name.substring(0, pos));
                result = this.createPackage(name, null, parent);
            } else {
                result = this.createPackage(name, null, null);
            }
            result.setCategory(CATEGORY_PACKAGE);
        }
        return result;
    }

    public void fixGroupCategory() {
        for (DElement element : this.getElements()) {
            DGroup group;
            if (element.getKind() != DElementKind.GROUP || (group = (DGroup)element).getCategory() != null) continue;
            group.setCategory(CATEGORY_FOLDER);
        }
    }

    public final void addAnonymousFeature() {
        for (DElement element : this.getElements()) {
            DItem type;
            if (element.getKind() != DElementKind.ITEM || !DJavaAnalysis.isAnonymousClass((type = (DItem)element).getName())) continue;
            type.setEnabled(FEATURE_ANONYMOUS, true);
        }
    }

    public final void addNestedFeature() {
        for (DElement element : this.getElements()) {
            DItem type;
            if (element.getKind() != DElementKind.ITEM || !DJavaAnalysis.isNestedClass((type = (DItem)element).getName())) continue;
            type.setEnabled(FEATURE_NESTED, true);
        }
    }

    public final void collapseAnonymousClasses() {
        LOGGER.info("collapseAnonymousClasses()");
        this.collapse(IS_ANONYMOUS_CLASS);
    }

    public final void collapseHiddenTypes() {
        LOGGER.info("collapseHiddenTypes()");
        this.collapse(IS_HIDDEN_TYPE);
    }

    public final void collapseTypes() {
        LOGGER.info("collapseTypes()");
        this.collapse(IS_TYPE);
    }

    public static boolean isStandardJavaName(String name) {
        return name.startsWith("java") || name.startsWith("sun");
    }

    public static boolean isPackageInfo(String name) {
        return name.endsWith("package-info");
    }

    public static String getParent(String name) {
        int pos = name.lastIndexOf(36);
        if (pos >= 0) {
            return name.substring(0, pos);
        }
        pos = name.lastIndexOf(47);
        if (pos >= 0) {
            return name.substring(0, pos);
        }
        return "";
    }

    public static String getPackagePart(String name) {
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            return name.substring(0, pos);
        }
        return "";
    }

    public static String getClassPart(String name) {
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            return name.substring(pos + 1);
        }
        return name;
    }

    public static String getLastClass(String name) {
        int pos = name.lastIndexOf(36);
        if (pos >= 0) {
            return name.substring(pos + 1);
        }
        return DJavaAnalysis.getClassPart(name);
    }

    public static boolean isAnonymousClass(String name) {
        String last = DJavaAnalysis.getLastClass(name);
        return StringRecognizer.isInt((String)last);
    }

    public static boolean isNamedClass(String name) {
        return !DJavaAnalysis.isAnonymousClass(name);
    }

    public static boolean isNestedClass(String name) {
        int pos = name.lastIndexOf(36);
        return pos >= 0;
    }

    public static String getOwningNamedClass(String name) {
        String tmp = name;
        while (DJavaAnalysis.isAnonymousClass(tmp)) {
            tmp = DJavaAnalysis.getParent(tmp);
        }
        return tmp;
    }
}

