/*
 * Decompiled with CFR 0.152.
 */
package cdc.deps.java.asm;

import cdc.deps.DGroup;
import cdc.deps.java.DJavaAnalyzer;
import cdc.deps.java.asm.AsmDependencyVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.TraceClassVisitor;

public class AsmJavaAnalyzer
extends DJavaAnalyzer {
    private static final Logger LOGGER = LogManager.getLogger(AsmJavaAnalyzer.class);

    public AsmJavaAnalyzer() {
        this.getAnalysis().getInfo().setCreationDate(new Date());
        this.getAnalysis().getInfo().setAnalyzerName(AsmJavaAnalyzer.class.getCanonicalName());
    }

    @Override
    protected void analyzeClassFile(DGroup group, InputStream is) {
        try {
            AsmDependencyVisitor v = new AsmDependencyVisitor(this, group, null);
            if (this.isEnabled(DJavaAnalyzer.Feature.DEBUG)) {
                PrintStream out = IoBuilder.forLogger((Logger)LOGGER).setLevel(Level.DEBUG).buildPrintStream();
                PrintWriter pw = new PrintWriter(out);
                TraceClassVisitor tcv = new TraceClassVisitor((ClassVisitor)v, pw);
                new ClassReader(is).accept((ClassVisitor)tcv, 0);
            } else {
                new ClassReader(is).accept((ClassVisitor)v, 0);
            }
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
        }
    }
}

