/*
 * Decompiled with CFR 0.152.
 */
package cdc.deps.java;

import cdc.deps.DAnalysis;
import cdc.deps.io.xml.DAnalysisXmlWriter;
import cdc.deps.java.DJavaAnalysis;
import cdc.deps.java.DJavaAnalyzer;
import cdc.deps.java.Engine;
import cdc.deps.java.asm.AsmJavaAnalyzer;
import cdc.util.cli.AbstractMainSupport;
import cdc.util.cli.FeatureMask;
import cdc.util.files.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JavaDeps {
    protected static final Logger LOGGER = LogManager.getLogger(JavaDeps.class);
    private final MainArgs margs;
    private static final String ALIAS_SEPARATOR = "::";
    private static final String CLASS_FILE = "class";
    private static final String CLASS_PATH = "class-path";
    private static final String JAR_FILE = "jar";

    private JavaDeps(MainArgs margs) {
        this.margs = margs;
    }

    private void execute() throws Exception {
        AsmJavaAnalyzer analyzer = this.margs.engine == Engine.ASM ? new AsmJavaAnalyzer() : null;
        if (analyzer != null) {
            for (DJavaAnalyzer.Feature feature : DJavaAnalyzer.Feature.values()) {
                analyzer.setEnabled(feature, this.margs.isEnabled(feature));
            }
            for (Map.Entry entry : this.margs.aliases.entrySet()) {
                analyzer.getAnalysis().addAlias((String)entry.getKey(), (String)entry.getValue());
            }
            for (String string : this.margs.jarFiles) {
                analyzer.analyzeJarFile(new File(string));
            }
            for (String string : this.margs.classPaths) {
                analyzer.analyzeClassPath(new File(string));
            }
            for (String string : this.margs.classFiles) {
                analyzer.analyzeClassFile(new File(string));
            }
            analyzer.postAnalysis();
            String path = this.margs.output.getParent();
            if (path != null) {
                Files.mkdir((String)path);
            }
            this.setInfo(analyzer);
            DAnalysisXmlWriter.write((DAnalysis)analyzer.getAnalysis(), (File)this.margs.output);
        }
    }

    private static void addAnalysisArgument(DJavaAnalysis analysis, String name, String value) {
        if (analysis.getAlias(value) != null) {
            analysis.getInfo().addAnalysisArgument(name, value + ALIAS_SEPARATOR + analysis.getAlias(value));
        } else {
            analysis.getInfo().addAnalysisArgument(name, value);
        }
    }

    private void setInfo(DJavaAnalyzer analyzer) {
        DJavaAnalysis analysis = analyzer.getAnalysis();
        for (DJavaAnalyzer.Feature feature : DJavaAnalyzer.Feature.values()) {
            if (!this.margs.isEnabled(feature)) continue;
            analysis.getInfo().addAnalysisArgument(feature.getName());
        }
        for (String filename : this.margs.jarFiles) {
            JavaDeps.addAnalysisArgument(analysis, JAR_FILE, filename);
        }
        for (String filename : this.margs.classFiles) {
            JavaDeps.addAnalysisArgument(analysis, CLASS_FILE, filename);
        }
        for (String path : this.margs.classPaths) {
            JavaDeps.addAnalysisArgument(analysis, CLASS_PATH, path);
        }
    }

    public static void execute(MainArgs margs) throws Exception {
        JavaDeps main = new JavaDeps(margs);
        main.execute();
    }

    public static void main(String[] args) {
        MainSupport support = new MainSupport();
        support.main(args);
    }

    private static class MainSupport
    extends AbstractMainSupport<MainArgs, Void> {
        private static final String ENGINE = "engine";

        MainSupport() {
            super(JavaDeps.class, LOGGER);
        }

        protected String getVersion() {
            return "0.2.0";
        }

        protected String getHelpFooter() {
            return "\nAt least one of class, class-path or jar option must be set.";
        }

        protected void addSpecificOptions(Options options) {
            options.addOption(Option.builder().longOpt("output").hasArg().desc("Optional name of the output filename (default deps.xml).").build());
            options.addOption(Option.builder().longOpt(JavaDeps.CLASS_FILE).hasArgs().desc("Optional name(s) of one or several class files. Has the form: filename[::alias]").build());
            options.addOption(Option.builder().longOpt(JavaDeps.CLASS_PATH).hasArgs().desc("Optional name(s) of one or several class paths. Has the form: dirname[::alias]").build());
            options.addOption(Option.builder().longOpt(JavaDeps.JAR_FILE).hasArgs().desc("Optional name(s) of one or several jar files. Has the form: jar[::alias]").build());
            options.addOption(Option.builder().longOpt(ENGINE).hasArg().desc("Optional name of the engine to use (default ASM).").build());
            MainSupport.addNoArgOptions((Options)options, DJavaAnalyzer.Feature.class);
        }

        private static String getName(String s) {
            return MainSupport.getPart1((String)s, (String)JavaDeps.ALIAS_SEPARATOR);
        }

        private static String getAlias(String s) {
            return MainSupport.getPart2((String)s, (String)JavaDeps.ALIAS_SEPARATOR, null);
        }

        private static void analyze(String s, List<String> names, Map<String, String> aliases) {
            String name = Files.normalize((String)new File(MainSupport.getName(s)).getPath());
            String alias = MainSupport.getAlias(s);
            names.add(name);
            if (alias != null) {
                aliases.put(name, alias);
            }
        }

        protected MainArgs analyze(CommandLine cl) throws ParseException {
            MainArgs margs = new MainArgs();
            margs.output = new File(cl.getOptionValue("output", "deps.xml"));
            margs.engine = (Engine)MainSupport.getValueAsEnum((CommandLine)cl, (String)ENGINE, Engine.class, (Enum)Engine.ASM);
            if (cl.getOptionValues(JavaDeps.JAR_FILE) != null) {
                for (String s : cl.getOptionValues(JavaDeps.JAR_FILE)) {
                    MainSupport.analyze(s, margs.jarFiles, margs.aliases);
                }
            }
            if (cl.getOptionValues(JavaDeps.CLASS_FILE) != null) {
                for (String s : cl.getOptionValues(JavaDeps.CLASS_FILE)) {
                    MainSupport.analyze(s, margs.classFiles, margs.aliases);
                }
            }
            if (cl.getOptionValues(JavaDeps.CLASS_PATH) != null) {
                for (String s : cl.getOptionValues(JavaDeps.CLASS_PATH)) {
                    MainSupport.analyze(s, margs.classPaths, margs.aliases);
                }
            }
            if (margs.classFiles.isEmpty() && margs.classPaths.isEmpty() && margs.jarFiles.isEmpty()) {
                throw new ParseException("Missing class, class-path or jar.");
            }
            MainSupport.setMask((CommandLine)cl, DJavaAnalyzer.Feature.class, (arg_0, arg_1) -> margs.features.setEnabled(arg_0, arg_1));
            return margs;
        }

        protected Void execute(MainArgs margs) throws Exception {
            JavaDeps.execute(margs);
            return null;
        }
    }

    public static class MainArgs {
        public final List<String> jarFiles = new ArrayList<String>();
        public final List<String> classPaths = new ArrayList<String>();
        public final List<String> classFiles = new ArrayList<String>();
        public final Map<String, String> aliases = new HashMap<String, String>();
        public File output;
        public Engine engine;
        protected final FeatureMask<DJavaAnalyzer.Feature> features = new FeatureMask();

        public void setEnabled(DJavaAnalyzer.Feature feature, boolean enabled) {
            this.features.setEnabled((Enum)feature, enabled);
        }

        public boolean isEnabled(DJavaAnalyzer.Feature feature) {
            return this.features.isEnabled((Enum)feature);
        }
    }
}

