/*
 * Decompiled with CFR 0.152.
 */
package cdc.deps.java;

import cdc.deps.DElementScope;
import cdc.deps.DGroup;
import cdc.deps.java.DJavaAnalysis;
import cdc.util.cli.OptionEnum;
import cdc.util.files.Files;
import cdc.util.lang.IntMasks;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DJavaAnalyzer {
    private static final Logger LOGGER = LogManager.getLogger(DJavaAnalyzer.class);
    private final DJavaAnalysis analysis = new DJavaAnalysis();
    private int features = 0;

    protected DJavaAnalyzer() {
    }

    protected void log(String message) {
        if (this.isEnabled(Feature.VERBOSE)) {
            LOGGER.info(message);
        }
    }

    public final void setEnabled(Feature feature, boolean enabled) {
        this.features = IntMasks.setEnabled((int)this.features, (Enum)feature, (boolean)enabled);
    }

    public final boolean isEnabled(Feature feature) {
        return IntMasks.isEnabled((int)this.features, (Enum)feature);
    }

    public final DJavaAnalysis getAnalysis() {
        return this.analysis;
    }

    public final void analyzeClassFile(File file) throws Exception {
        this.log("analyzeClassFile(" + file + ")");
        if (file.isFile()) {
            DGroup refGroup = this.analysis.createGroup(this.analysis.getAliasOrName(Files.normalize((String)file.getPath())), null);
            refGroup.setScope(DElementScope.INTERNAL);
            refGroup.setCategory("Java.ClassFile");
            this.analyzeClassFile(refGroup, file);
        } else {
            LOGGER.warn("analyzeClassFile(" + file + "): invalid file");
        }
    }

    private final void analyzeClassFile(DGroup group, File file) throws Exception {
        try (FileInputStream is = new FileInputStream(file);){
            this.analyzeClassFile(group, is);
        }
        catch (Exception e) {
            LOGGER.error("analyzeClassFile(" + group + ", " + file + ") FAILED", (Throwable)e);
            throw e;
        }
    }

    public final void analyzeClassPath(File classpath) throws Exception {
        this.log("analyzeClassPath(" + classpath + ")");
        if (classpath.isDirectory()) {
            DGroup refGroup = this.analysis.createGroup(this.analysis.getAliasOrName(Files.normalize((String)classpath.getPath())), null);
            refGroup.setScope(DElementScope.INTERNAL);
            refGroup.setCategory("Java.Folder");
            this.analyzeClassPathRec(refGroup, classpath, null);
        } else {
            LOGGER.warn("analyzeClassPath(" + classpath + "): invalid path");
        }
    }

    private final void analyzeClassPathRec(DGroup refGroup, File classpath, File relativePath) throws Exception {
        File fullPath;
        this.log("analyzeClassPathRec(" + refGroup + ", " + classpath + ", " + relativePath + ")");
        File file = fullPath = relativePath == null ? classpath : new File(classpath, relativePath.getPath());
        if (fullPath.isDirectory()) {
            String[] files = fullPath.list();
            if (files != null) {
                for (String file2 : files) {
                    File nextRelativePath = new File(relativePath, file2);
                    if (nextRelativePath.getPath().endsWith(".class")) {
                        DGroup group = this.analysis.findOrCreateGroup(refGroup, nextRelativePath);
                        group.setScope(DElementScope.INTERNAL);
                        group.setCategory("Java.Class");
                        this.analyzeClassFile(group, new File(classpath, nextRelativePath.getPath()));
                        continue;
                    }
                    File nextFullPath = new File(classpath, nextRelativePath.getPath());
                    if (!nextFullPath.isDirectory()) continue;
                    this.analyzeClassPathRec(refGroup, classpath, nextRelativePath);
                }
            }
        } else {
            LOGGER.error("Invalid directory: " + fullPath);
        }
    }

    public final void analyzeJarFile(File jar) throws Exception {
        block10: {
            this.log("analyzeJarFile(" + jar + ")");
            if (jar.isFile()) {
                DGroup refGroup = this.analysis.createGroup(this.analysis.getAliasOrName(Files.normalize((String)jar.getPath())), null);
                refGroup.setScope(DElementScope.INTERNAL);
                refGroup.setCategory("Java.Archive");
                try (ZipFile archive = new ZipFile(jar);){
                    Enumeration<? extends ZipEntry> iter = archive.entries();
                    while (iter.hasMoreElements()) {
                        ZipEntry entry = iter.nextElement();
                        String name = entry.getName();
                        if (!name.endsWith(".class")) continue;
                        if (name.startsWith("META-INF/version")) {
                            LOGGER.warn("Ignore multi version class " + name);
                            continue;
                        }
                        DGroup group = this.analysis.findOrCreateGroup(refGroup, new File(name));
                        group.setScope(DElementScope.INTERNAL);
                        group.setCategory("Java.Class");
                        this.analyzeClassFile(group, archive.getInputStream(entry));
                    }
                    break block10;
                }
                catch (Exception e) {
                    LOGGER.catching((Throwable)e);
                    throw e;
                }
            }
            LOGGER.warn("analyzeJarFile(" + jar + "): invalid jar");
        }
    }

    public void postAnalysis() {
        this.analysis.fixGroupCategory();
        this.analysis.addAnonymousFeature();
        this.analysis.addNestedFeature();
        this.analysis.checkScopes();
        this.analysis.checkCategory();
        if (this.isEnabled(Feature.COLLAPSE_ANONYMOUS_CLASSES)) {
            this.analysis.collapseAnonymousClasses();
        }
        if (this.isEnabled(Feature.COLLAPSE_HIDDEN_TYPES)) {
            this.analysis.collapseHiddenTypes();
        }
        if (this.isEnabled(Feature.COLLAPSE_TYPES)) {
            this.analysis.collapseTypes();
        }
        if (this.isEnabled(Feature.ADD_ROOT_GROUP_DEPENDENCIES)) {
            this.analysis.createRootGroupsDerivedDependencies();
        }
        if (this.isEnabled(Feature.ADD_PACKAGE_DEPENDENCIES)) {
            this.analysis.createPackageDerivedDependencies();
        }
    }

    protected abstract void analyzeClassFile(DGroup var1, InputStream var2);

    public static enum Feature implements OptionEnum
    {
        VERBOSE("verbose", "Be verbose."),
        DEBUG("debug", "Print debug infos."),
        IGNORE_ANNOTATIONS("no-annotation-types", "Do not generate info related to annotation types."),
        IGNORE_JDK_TYPES("no-jdk-types", "Do not generate info related to jdk types."),
        IGNORE_PACKAGE_INFO("no-package-info", "Do not generate info related to package-info.java."),
        COLLAPSE_ANONYMOUS_CLASSES("no-anonymous-classes", "Do not show anonymous classes."),
        COLLAPSE_HIDDEN_TYPES("no-hidden-types", "Do not show hidden (anonymous classes or private nested classes) types."),
        COLLAPSE_TYPES("no-types", "Do not show types. They are collapsed into packages."),
        ADD_ROOT_GROUP_DEPENDENCIES("root-group-deps", "Create root group dependencies (computed from classes dependencies)."),
        ADD_PACKAGE_DEPENDENCIES("package-deps", "Create package dependencies (computed from classes dependencies).");

        private final String name;
        private final String description;

        private Feature(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        public final String getDescription() {
            return this.description;
        }
    }
}

