/*
 * Decompiled with CFR 0.152.
 */
package cdc.deps.java.asm;

import cdc.deps.DElement;
import cdc.deps.DElementScope;
import cdc.deps.DGroup;
import cdc.deps.DItem;
import cdc.deps.java.DJavaAnalysis;
import cdc.deps.java.DJavaAnalyzer;
import cdc.deps.java.asm.AsmJavaAnalyzer;
import cdc.util.debug.CallStack;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

class AsmDependencyVisitor
extends ClassVisitor {
    protected static final Logger LOGGER = LogManager.getLogger(AsmDependencyVisitor.class);
    private static final int ASM_VERSION = 458752;
    protected static final SignatureVisitor VOID_SIGNATURE_VISITOR = new SignatureVisitor(458752){};
    protected final AsmJavaAnalyzer analyzer;
    private final DGroup group;
    private DItem type;

    public AsmDependencyVisitor(AsmJavaAnalyzer analyzer, DGroup group) {
        super(458752);
        this.analyzer = analyzer;
        this.group = group;
    }

    public AsmDependencyVisitor(AsmJavaAnalyzer analyzer, DGroup group, ClassVisitor v) {
        super(458752, v);
        this.analyzer = analyzer;
        this.group = group;
    }

    private static boolean isSet(int mask, int code) {
        return (mask & code) != 0;
    }

    private static void addAccess(StringBuilder builder, int access, int opcode, String s) {
        if (AsmDependencyVisitor.isSet(access, opcode)) {
            builder.append(" ");
            builder.append(s);
        }
    }

    private static String accessToString(int access, AccessContext context) {
        StringBuilder builder = new StringBuilder();
        builder.append("0x" + Integer.toHexString(access));
        builder.append(" [");
        builder.append((Object)context);
        builder.append("]");
        AsmDependencyVisitor.addAccess(builder, access, 1, "public");
        AsmDependencyVisitor.addAccess(builder, access, 2, "private");
        AsmDependencyVisitor.addAccess(builder, access, 4, "protected");
        AsmDependencyVisitor.addAccess(builder, access, 8, "static");
        AsmDependencyVisitor.addAccess(builder, access, 16, "final");
        if (context == AccessContext.CLASS) {
            AsmDependencyVisitor.addAccess(builder, access, 32, "super");
        } else if (context == AccessContext.METHOD) {
            AsmDependencyVisitor.addAccess(builder, access, 32, "synchronized");
        } else if (context == AccessContext.MODULE) {
            AsmDependencyVisitor.addAccess(builder, access, 32, "open");
        } else {
            AsmDependencyVisitor.addAccess(builder, access, 32, "transitive");
        }
        if (context == AccessContext.FIELD) {
            AsmDependencyVisitor.addAccess(builder, access, 64, "volatile");
        } else if (context == AccessContext.METHOD) {
            AsmDependencyVisitor.addAccess(builder, access, 64, "bridge");
        } else {
            AsmDependencyVisitor.addAccess(builder, access, 64, "static-phase");
        }
        if (context == AccessContext.METHOD) {
            AsmDependencyVisitor.addAccess(builder, access, 128, "varargs");
        } else {
            AsmDependencyVisitor.addAccess(builder, access, 128, "transient");
        }
        AsmDependencyVisitor.addAccess(builder, access, 256, "native");
        AsmDependencyVisitor.addAccess(builder, access, 512, "interface");
        AsmDependencyVisitor.addAccess(builder, access, 1024, "abstract");
        AsmDependencyVisitor.addAccess(builder, access, 2048, "strict");
        AsmDependencyVisitor.addAccess(builder, access, 4096, "synthetic");
        AsmDependencyVisitor.addAccess(builder, access, 8192, "annotation");
        AsmDependencyVisitor.addAccess(builder, access, 16384, "enum");
        if (context == AccessContext.CLASS) {
            AsmDependencyVisitor.addAccess(builder, access, 32768, "module");
        } else {
            AsmDependencyVisitor.addAccess(builder, access, 32768, "mandated");
        }
        AsmDependencyVisitor.addAccess(builder, access, 131072, "deprecated");
        return builder.toString();
    }

    boolean debugEnabled() {
        return this.analyzer.isEnabled(DJavaAnalyzer.Feature.DEBUG);
    }

    void enter(String message) {
        if (this.debugEnabled()) {
            CallStack.enter((String)message);
        }
    }

    void leave() {
        if (this.debugEnabled()) {
            CallStack.leave();
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.debugEnabled()) {
            this.enter("ASM.visit(version:" + version + ", access:" + AsmDependencyVisitor.accessToString(access, AccessContext.CLASS) + ", name:" + name + ", sig:" + signature + ", super:" + superName + ", inter:" + Arrays.toString(interfaces) + ")");
        }
        this.type = this.createOrFindType(name, this.group);
        if (this.type != null) {
            this.type.setScope(DElementScope.INTERNAL);
            if (AsmDependencyVisitor.isSet(access, 512)) {
                this.type.setCategory("Java.Interface");
            } else if (AsmDependencyVisitor.isSet(access, 16384)) {
                this.type.setCategory("Java.Enum");
            } else {
                this.type.setCategory("Java.Class");
            }
            if (!DJavaAnalysis.isNestedClass(name)) {
                this.analyseAccess(this.type, access, AccessContext.CLASS);
            }
            if (signature != null && this.isSignatureOfGenericClass(signature)) {
                this.type.setEnabled("GENERIC", true);
            }
            this.parseInternalName(superName);
            this.parseInternalNames(interfaces);
            this.parseSignature(signature);
        }
        this.leave();
    }

    public void visitSource(String source, String debug) {
        if (this.debugEnabled()) {
            this.enter("ASM.visitSource(source:" + source + ", debug:" + debug + ")");
            this.leave();
        }
    }

    public ModuleVisitor visitModule(String name, int access, String version) {
        LOGGER.error("ASM.visitModule() NYI");
        return super.visitModule(name, access, version);
    }

    public void visitNestHost(String nestHost) {
        LOGGER.error("ASM.visitNestHost() NYI");
        super.visitNestHost(nestHost);
    }

    public void visitNestMember(String nestMember) {
        LOGGER.error("ASM.visitNestMember() NYI");
        super.visitNestMember(nestMember);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        if (this.debugEnabled()) {
            this.enter("ASM.visitOuterClass(owner:" + owner + ", name:" + name + ", desc:" + desc + ")");
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.debugEnabled()) {
            this.enter("ASM.visitAnnotation(desc:" + desc + "visible:" + visible + ")");
        }
        try {
            if (this.analyzer.isEnabled(DJavaAnalyzer.Feature.IGNORE_ANNOTATIONS)) {
                AnnotationVisitor annotationVisitor = null;
                return annotationVisitor;
            }
            this.parseDesc(desc);
            AnnotationDependencyVisitor annotationDependencyVisitor = new AnnotationDependencyVisitor();
            return annotationDependencyVisitor;
        }
        finally {
            this.leave();
        }
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        LOGGER.error("ASM.visitTypeAnnotation() NYI");
        return super.visitTypeAnnotation(typeRef, typePath, desc, visible);
    }

    public void visitAttribute(Attribute attr) {
        if (this.debugEnabled()) {
            this.enter("ASM.visitAttribute(attrs:" + attr + ")");
            this.leave();
        }
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.debugEnabled()) {
            this.enter("ASM.visitInnerClass(name:" + name + ", outer:" + outerName + ", inner:" + innerName + ", access:" + AsmDependencyVisitor.accessToString(access, AccessContext.INNER) + ")");
        }
        DItem inner = this.createOrFindType(name, null);
        this.analyseAccess(inner, access, AccessContext.INNER);
        this.leave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.debugEnabled()) {
            this.enter("ASM.visitField(access:" + AsmDependencyVisitor.accessToString(access, AccessContext.FIELD) + ", name:" + name + ", desc:" + desc + ", sig:" + signature + ", value:" + value + ")");
        }
        try {
            if (signature == null) {
                this.parseDesc(desc);
            } else {
                this.parseSignature(signature);
            }
            if (value instanceof Type) {
                this.parseType((Type)value);
            }
            FieldDependencyVisitor fieldDependencyVisitor = new FieldDependencyVisitor();
            return fieldDependencyVisitor;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.debugEnabled()) {
            this.enter("ASM.visitMethod(access:" + AsmDependencyVisitor.accessToString(access, AccessContext.METHOD) + ", name:" + name + ", desc:" + desc + ", sig:" + signature + ", exceptions:" + Arrays.toString(exceptions) + ")");
        }
        try {
            if (signature == null) {
                this.parseMethodDesc(desc);
            } else {
                this.parseSignature(signature);
            }
            this.parseInternalNames(exceptions);
            MethodDependencyVisitor methodDependencyVisitor = new MethodDependencyVisitor();
            return methodDependencyVisitor;
        }
        finally {
            this.leave();
        }
    }

    public void visitEnd() {
        if (this.debugEnabled()) {
            this.enter("ASM.visitEnd()");
            this.leave();
        }
    }

    private void analyseAccess(DItem type, int access, AccessContext context) {
        if (this.debugEnabled()) {
            this.enter("analyseAccess(" + type + ", " + AsmDependencyVisitor.accessToString(access, context) + ")");
        }
        if (type != null) {
            if (AsmDependencyVisitor.isSet(access, 1)) {
                type.setEnabled("PUBLIC", true);
                type.setEnabled("PACKAGE", false);
            } else if (AsmDependencyVisitor.isSet(access, 4)) {
                type.setEnabled("PROTECTED", true);
                type.setEnabled("PACKAGE", false);
            } else if (AsmDependencyVisitor.isSet(access, 2)) {
                type.setEnabled("PRIVATE", true);
                type.setEnabled("PACKAGE", false);
            } else {
                type.setEnabled("PACKAGE", true);
            }
            if (AsmDependencyVisitor.isSet(access, 1024)) {
                type.setEnabled("ABSTRACT", true);
            }
            if (AsmDependencyVisitor.isSet(access, 8)) {
                type.setEnabled("STATIC", true);
            }
            if (AsmDependencyVisitor.isSet(access, 16)) {
                type.setEnabled("FINAL", true);
            }
            if (AsmDependencyVisitor.isSet(access, 131072)) {
                type.setEnabled("DEPRECATED", true);
            }
            if (context == AccessContext.INNER) {
                if (AsmDependencyVisitor.isSet(access, 512)) {
                    type.setCategory("Java.Interface");
                } else if (AsmDependencyVisitor.isSet(access, 16384)) {
                    type.setCategory("Java.Enum");
                } else {
                    type.setCategory("Java.Class");
                }
            }
        }
        this.leave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DItem createOrFindType(String typename, DGroup group) {
        if (this.debugEnabled()) {
            this.enter("createOrFindType(" + typename + ", " + group + ")");
        }
        try {
            if (this.analyzer.isEnabled(DJavaAnalyzer.Feature.IGNORE_JDK_TYPES) && DJavaAnalysis.isStandardJavaName(typename) || this.analyzer.isEnabled(DJavaAnalyzer.Feature.IGNORE_PACKAGE_INFO) && DJavaAnalysis.isPackageInfo(typename)) {
                DItem dItem = null;
                return dItem;
            }
            DItem dItem = this.analyzer.getAnalysis().findOrCreateItem(typename, group);
            return dItem;
        }
        finally {
            this.leave();
        }
    }

    private void createDependency(String typename) {
        DItem depType;
        if (this.debugEnabled()) {
            this.enter("createDependency(" + typename + ")");
        }
        if (typename != null && (depType = this.createOrFindType(typename, null)) != null) {
            this.enter("addDependency(" + this.type + ", " + depType + ")");
            this.analyzer.getAnalysis().addPrimitiveDependency((DElement)this.type, (DElement)depType);
            this.leave();
        }
        this.leave();
    }

    void parseDesc(String desc) {
        if (this.debugEnabled()) {
            this.enter("parseDesc(desc:" + desc + ")");
        }
        this.parseType(Type.getType((String)desc));
        this.leave();
    }

    void parseInternalName(String name) {
        if (this.debugEnabled()) {
            this.enter("parseInternalName(name:" + name + ")");
        }
        this.parseType(Type.getObjectType((String)name));
        this.leave();
    }

    private void parseInternalNames(String[] names) {
        if (this.debugEnabled()) {
            this.enter("parseInternalNames(names:" + Arrays.toString(names) + ")");
        }
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                this.parseInternalName(names[i]);
            }
        }
        this.leave();
    }

    void parseType(Type type) {
        if (this.debugEnabled()) {
            this.enter("parseType(type:" + type + ")");
        }
        switch (type.getSort()) {
            case 9: {
                this.parseType(type.getElementType());
                break;
            }
            case 10: {
                this.createDependency(type.getInternalName());
                break;
            }
            case 11: {
                this.parseMethodDesc(type.getDescriptor());
                break;
            }
        }
        this.leave();
    }

    void parseMethodDesc(String desc) {
        Type[] types;
        if (this.debugEnabled()) {
            this.enter("parseMethodDesc(desc:" + desc + ")");
        }
        this.parseType(Type.getReturnType((String)desc));
        for (Type type2 : types = Type.getArgumentTypes((String)desc)) {
            this.parseType(type2);
        }
        this.leave();
    }

    void parseSignature(String signature) {
        if (this.debugEnabled()) {
            this.enter("parseSignature(signature:" + signature + ")");
        }
        try {
            if (signature != null) {
                new SignatureReader(signature).accept((SignatureVisitor)new SignatureDependencyVisitor());
            }
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSignatureOfGenericClass(String signature) {
        if (this.debugEnabled()) {
            this.enter("parseSignature(signature:" + signature + ")");
        }
        try {
            if (signature == null) {
                boolean bl = false;
                return bl;
            }
            SignatureAnalyzerVisitor visitor = new SignatureAnalyzerVisitor();
            new SignatureReader(signature).accept((SignatureVisitor)visitor);
            boolean bl = visitor.foundGenericClass();
            return bl;
        }
        finally {
            this.leave();
        }
    }

    void parseConstant(Object constant) {
        if (this.debugEnabled()) {
            this.enter("parseConstant(constant:" + constant + ")");
        }
        if (constant instanceof Type) {
            this.parseType((Type)constant);
        } else if (constant instanceof Handle) {
            Handle handle = (Handle)constant;
            this.parseInternalName(handle.getOwner());
            this.parseMethodDesc(handle.getDesc());
        }
        this.leave();
    }

    private static enum AccessContext {
        CLASS,
        FIELD,
        INNER,
        METHOD,
        PARAMETER,
        MODULE;

    }

    private class AnnotationDependencyVisitor
    extends AnnotationVisitor {
        public AnnotationDependencyVisitor() {
            super(458752);
        }

        private String getContext() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void visit(String name, Object value) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visit(name:" + name + ", value:" + value + ")");
            }
            if (value instanceof Type) {
                AsmDependencyVisitor.this.parseType((Type)value);
            }
            AsmDependencyVisitor.this.leave();
        }

        public void visitEnum(String name, String desc, String value) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitEnum(name:" + name + ", desc:" + desc + ", value:" + value + ")");
            }
            AsmDependencyVisitor.this.parseDesc(desc);
            AsmDependencyVisitor.this.leave();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitAnnotation(name:" + name + ", desc:" + desc + ")");
            }
            try {
                AsmDependencyVisitor.this.parseDesc(desc);
                AnnotationDependencyVisitor annotationDependencyVisitor = this;
                return annotationDependencyVisitor;
            }
            finally {
                AsmDependencyVisitor.this.leave();
            }
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }

        public void visitEnd() {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitEnd()");
                AsmDependencyVisitor.this.leave();
            }
        }
    }

    private class FieldDependencyVisitor
    extends FieldVisitor {
        public FieldDependencyVisitor() {
            super(458752);
        }

        private String getContext() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitAnnotation(desc:" + desc + ", visible:" + visible + ")");
            }
            try {
                AsmDependencyVisitor.this.parseDesc(desc);
                AnnotationDependencyVisitor annotationDependencyVisitor = new AnnotationDependencyVisitor();
                return annotationDependencyVisitor;
            }
            finally {
                AsmDependencyVisitor.this.leave();
            }
        }
    }

    private class MethodDependencyVisitor
    extends MethodVisitor {
        public MethodDependencyVisitor() {
            super(458752);
        }

        private String getContext() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }

        public AnnotationVisitor visitAnnotationDefault() {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitAnnotationDefault()");
            }
            try {
                AnnotationDependencyVisitor annotationDependencyVisitor = new AnnotationDependencyVisitor();
                return annotationDependencyVisitor;
            }
            finally {
                AsmDependencyVisitor.this.leave();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitAnnotation(desc:" + desc + ", visible:" + visible + ")");
            }
            try {
                AsmDependencyVisitor.this.parseDesc(desc);
                AnnotationDependencyVisitor annotationDependencyVisitor = new AnnotationDependencyVisitor();
                return annotationDependencyVisitor;
            }
            finally {
                AsmDependencyVisitor.this.leave();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitParameterAnnotation(parameter:" + parameter + ", desc:" + desc + ", visible:" + visible + ")");
            }
            try {
                AsmDependencyVisitor.this.parseDesc(desc);
                AnnotationDependencyVisitor annotationDependencyVisitor = new AnnotationDependencyVisitor();
                return annotationDependencyVisitor;
            }
            finally {
                AsmDependencyVisitor.this.leave();
            }
        }

        public void visitTypeInsn(int opcode, String type) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitTypeInsn(opcode:" + opcode + ", type:" + type + ")");
            }
            AsmDependencyVisitor.this.parseType(Type.getObjectType((String)type));
            AsmDependencyVisitor.this.leave();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitTypeAnnotation(..., desc:" + desc + ", ...)");
            }
            try {
                if (AsmDependencyVisitor.this.analyzer.isEnabled(DJavaAnalyzer.Feature.IGNORE_ANNOTATIONS)) {
                    AnnotationVisitor annotationVisitor = null;
                    return annotationVisitor;
                }
                AsmDependencyVisitor.this.parseDesc(desc);
                AnnotationDependencyVisitor annotationDependencyVisitor = new AnnotationDependencyVisitor();
                return annotationDependencyVisitor;
            }
            finally {
                AsmDependencyVisitor.this.leave();
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitFieldInsn(opcode:" + opcode + ", ...)");
            }
            AsmDependencyVisitor.this.parseInternalName(owner);
            AsmDependencyVisitor.this.parseDesc(desc);
            AsmDependencyVisitor.this.leave();
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitMethodInsn(opcode:" + opcode + ", ...)");
            }
            AsmDependencyVisitor.this.parseInternalName(owner);
            AsmDependencyVisitor.this.parseMethodDesc(desc);
            AsmDependencyVisitor.this.leave();
        }

        @Deprecated
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitMethodInsn(opcode:" + opcode + ", ...)");
            }
            AsmDependencyVisitor.this.parseInternalName(owner);
            AsmDependencyVisitor.this.parseMethodDesc(desc);
            AsmDependencyVisitor.this.leave();
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitInvokeDynamicInsn(name:" + name + ", ...)");
            }
            AsmDependencyVisitor.this.parseMethodDesc(desc);
            AsmDependencyVisitor.this.parseConstant(bsm);
            for (Object bsmArg : bsmArgs) {
                AsmDependencyVisitor.this.parseConstant(bsmArg);
            }
            AsmDependencyVisitor.this.leave();
        }

        public void visitLdcInsn(Object constant) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitLdcInsn(constant:" + constant + ")");
            }
            AsmDependencyVisitor.this.parseConstant(constant);
            AsmDependencyVisitor.this.leave();
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitMultiANewArrayInsn(desc:" + desc + ", dims:" + dims + ")");
            }
            AsmDependencyVisitor.this.parseDesc(desc);
            AsmDependencyVisitor.this.leave();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitInsnAnnotation(..., desc:" + desc + ", ...)");
            }
            try {
                if (AsmDependencyVisitor.this.analyzer.isEnabled(DJavaAnalyzer.Feature.IGNORE_ANNOTATIONS)) {
                    AnnotationVisitor annotationVisitor = null;
                    return annotationVisitor;
                }
                AsmDependencyVisitor.this.parseDesc(desc);
                AnnotationDependencyVisitor annotationDependencyVisitor = new AnnotationDependencyVisitor();
                return annotationDependencyVisitor;
            }
            finally {
                AsmDependencyVisitor.this.leave();
            }
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitLocalVariable(name:" + name + ", desc:" + desc + ", ...)");
            }
            AsmDependencyVisitor.this.parseSignature(signature);
            AsmDependencyVisitor.this.leave();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitLocalVariableAnnotation(..., desc:" + desc + ", ...)");
            }
            try {
                if (AsmDependencyVisitor.this.analyzer.isEnabled(DJavaAnalyzer.Feature.IGNORE_ANNOTATIONS)) {
                    AnnotationVisitor annotationVisitor = null;
                    return annotationVisitor;
                }
                AsmDependencyVisitor.this.parseDesc(desc);
                AnnotationDependencyVisitor annotationDependencyVisitor = new AnnotationDependencyVisitor();
                return annotationDependencyVisitor;
            }
            finally {
                AsmDependencyVisitor.this.leave();
            }
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitTryCatchBlock(...)");
            }
            if (type != null) {
                AsmDependencyVisitor.this.parseInternalName(type);
            }
            AsmDependencyVisitor.this.leave();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitTryCatchAnnotation(..., desc:" + desc + ", ...)");
            }
            try {
                if (AsmDependencyVisitor.this.analyzer.isEnabled(DJavaAnalyzer.Feature.IGNORE_ANNOTATIONS)) {
                    AnnotationVisitor annotationVisitor = null;
                    return annotationVisitor;
                }
                AsmDependencyVisitor.this.parseDesc(desc);
                AnnotationDependencyVisitor annotationDependencyVisitor = new AnnotationDependencyVisitor();
                return annotationDependencyVisitor;
            }
            finally {
                AsmDependencyVisitor.this.leave();
            }
        }
    }

    private class SignatureDependencyVisitor
    extends SignatureVisitor {
        private String signatureClassName;

        public SignatureDependencyVisitor() {
            super(458752);
        }

        private String getContext() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode((Object)this));
        }

        private SignatureVisitor fork(String name) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".fork(" + name + ")");
            }
            try {
                SignatureDependencyVisitor signatureDependencyVisitor = new SignatureDependencyVisitor();
                return signatureDependencyVisitor;
            }
            finally {
                AsmDependencyVisitor.this.leave();
            }
        }

        public SignatureVisitor visitClassBound() {
            return this.fork("visitClassBound()");
        }

        public SignatureVisitor visitInterfaceBound() {
            return this.fork("visitInterfaceBound()");
        }

        public SignatureVisitor visitSuperclass() {
            return this.fork("visitSuperclass()");
        }

        public SignatureVisitor visitInterface() {
            return this.fork("visitInterface()");
        }

        public SignatureVisitor visitParameterType() {
            return this.fork("visitParameterType()");
        }

        public SignatureVisitor visitReturnType() {
            return this.fork("visitReturnType()");
        }

        public SignatureVisitor visitExceptionType() {
            return this.fork("visitExceptionType()");
        }

        public SignatureVisitor visitArrayType() {
            return this.fork("visitArrayType()");
        }

        public void visitClassType(String name) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitClassType(name:" + name + ")");
            }
            this.signatureClassName = name;
            AsmDependencyVisitor.this.parseInternalName(name);
            AsmDependencyVisitor.this.leave();
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            return this.fork("visitTypeArgument()");
        }

        public void visitInnerClassType(String name) {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitInnerClassType(name:" + name + ")");
            }
            AsmDependencyVisitor.this.parseInternalName(this.signatureClassName + "$" + name);
            AsmDependencyVisitor.this.leave();
        }

        public void visitEnd() {
            if (AsmDependencyVisitor.this.debugEnabled()) {
                AsmDependencyVisitor.this.enter("ASM." + this.getContext() + ".visitEnd()");
            }
            this.signatureClassName = null;
            AsmDependencyVisitor.this.leave();
        }
    }

    private class SignatureAnalyzerVisitor
    extends SignatureVisitor {
        private boolean hasFormalParameters;

        public SignatureAnalyzerVisitor() {
            super(458752);
            this.hasFormalParameters = false;
        }

        public boolean foundGenericClass() {
            return this.hasFormalParameters;
        }

        public void visitFormalTypeParameter(String name) {
            this.hasFormalParameters = true;
        }

        public SignatureVisitor visitClassBound() {
            return VOID_SIGNATURE_VISITOR;
        }

        public SignatureVisitor visitInterfaceBound() {
            return VOID_SIGNATURE_VISITOR;
        }

        public SignatureVisitor visitSuperclass() {
            return VOID_SIGNATURE_VISITOR;
        }

        public SignatureVisitor visitInterface() {
            return VOID_SIGNATURE_VISITOR;
        }

        public SignatureVisitor visitParameterType() {
            return VOID_SIGNATURE_VISITOR;
        }

        public SignatureVisitor visitReturnType() {
            return VOID_SIGNATURE_VISITOR;
        }

        public SignatureVisitor visitExceptionType() {
            return VOID_SIGNATURE_VISITOR;
        }

        public SignatureVisitor visitArrayType() {
            return VOID_SIGNATURE_VISITOR;
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            return VOID_SIGNATURE_VISITOR;
        }
    }
}

