/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api.locations;

import cdc.issues.api.IssueLocation;
import cdc.util.lang.Checks;

public class TextFileIssueLocation
implements IssueLocation {
    private final String systemId;
    private final int lineNumber;
    private final int columnNumber;

    private TextFileIssueLocation(String systemId, int lineNumber, int columnNumber) {
        this.systemId = (String)Checks.isNotNull((Object)systemId, (String)"systemId");
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    @Override
    public String getTargetId() {
        return this.getSystemId();
    }

    @Override
    public String getPath() {
        return this.getLineNumber() + ":" + this.getColumnNumber();
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String toString() {
        return this.getSystemId() + ":" + this.getLineNumber() + ":" + this.getColumnNumber();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String systemId;
        private int lineNumber;
        private int columnNumber;

        private Builder() {
        }

        public Builder systemId(String systemId) {
            this.systemId = systemId;
            return this;
        }

        public Builder lineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder columnNumber(int columnNumber) {
            this.columnNumber = columnNumber;
            return this;
        }

        public TextFileIssueLocation build() {
            return new TextFileIssueLocation(this.systemId, this.lineNumber, this.columnNumber);
        }
    }
}

