/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.Params;
import cdc.issues.locations.Location;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import java.util.Arrays;
import java.util.Objects;

public class IssueId {
    private final RuleId ruleId;
    private final Params params;
    private final String project;
    private final Location[] locations;

    public IssueId(RuleId ruleId, Params params, String project, Location ... locations) {
        this.ruleId = (RuleId)Checks.isNotNull((Object)ruleId, (String)"ruleId");
        this.params = (Params)Checks.isNotNull((Object)params, (String)"params");
        this.project = project;
        this.locations = (Location[])((Location[])Checks.isNotNull((Object)locations, (String)"locations")).clone();
        if (locations.length == 0) {
            throw new IllegalArgumentException("Empty locations");
        }
    }

    public IssueId(String domain, String name, Params params, String project, Location ... locations) {
        this(new RuleId(domain, name), params, project, locations);
    }

    public IssueId(RuleId ruleId, Params params, Location ... locations) {
        this(ruleId, params, (String)null, locations);
    }

    public IssueId(String domain, String name, Params params, Location ... locations) {
        this(domain, name, params, (String)null, locations);
    }

    public IssueId(String domain, Enum<?> name, Params params, String project, Location ... locations) {
        this(domain, name.name(), params, project, locations);
    }

    public IssueId(String domain, Enum<?> name, Params params, Location ... locations) {
        this(domain, name, params, (String)null, locations);
    }

    public RuleId getRuleId() {
        return this.ruleId;
    }

    public String getDomain() {
        return this.ruleId.getDomain();
    }

    public String getName() {
        return this.ruleId.getName();
    }

    public <T extends Enum<T>> T getName(Class<T> cls) {
        return this.ruleId.getName(cls);
    }

    public Params getParams() {
        return this.params;
    }

    public String getProject() {
        return this.project;
    }

    public Location[] getLocations() {
        return (Location[])this.locations.clone();
    }

    public int hashCode() {
        return Objects.hash(this.ruleId, this.params, this.project) + 31 * Arrays.hashCode(this.locations);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IssueId)) {
            return false;
        }
        IssueId other = (IssueId)object;
        return this.ruleId.equals(other.ruleId) && Objects.equals(this.params, other.params) && Objects.equals(this.project, other.project) && Arrays.equals(this.locations, other.locations);
    }

    public String toString() {
        return "[" + this.ruleId + " " + this.params + " " + this.project + " " + Arrays.toString(this.locations) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RuleId ruleId;
        private Params params;
        private String project;
        private Location[] locations;

        private Builder() {
        }

        public Builder ruleId(RuleId ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public Builder params(Params params) {
            this.params = params;
            return this;
        }

        public Builder project(String project) {
            this.project = project;
            return this;
        }

        public Builder locations(Location ... locations) {
            this.locations = locations;
            return this;
        }

        public IssueId build() {
            return new IssueId(this.ruleId, this.params, this.project, this.locations);
        }
    }
}

