/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.office.ss.WorkbookWriterFeatures;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.EnumSet;
import java.util.Set;

public final class IssuesFactoryFeatures {
    public static final IssuesFactoryFeatures UTC_BEST = IssuesFactoryFeatures.builder().workbookWriterFeatures(WorkbookWriterFeatures.builder().enable(WorkbookWriterFeatures.Feature.AUTO_FILTER_COLUMNS).enable(WorkbookWriterFeatures.Feature.AUTO_SIZE_COLUMNS).enable(WorkbookWriterFeatures.Feature.TRUNCATE_CELLS).build()).hint(Hint.PRETTY_PRINT).hint(Hint.VERBOSE).zoneId(ZoneOffset.UTC).build();
    public static final IssuesFactoryFeatures UTC_FASTEST = IssuesFactoryFeatures.builder().workbookWriterFeatures(WorkbookWriterFeatures.builder().enable(WorkbookWriterFeatures.Feature.AUTO_FILTER_COLUMNS).enable(WorkbookWriterFeatures.Feature.TRUNCATE_CELLS).build()).hint(Hint.PRETTY_PRINT).hint(Hint.VERBOSE).hint(Hint.POI_STREAMING).zoneId(ZoneOffset.UTC).build();
    private final WorkbookWriterFeatures workbookWriterFeatures;
    private final Set<Hint> hints = EnumSet.noneOf(Hint.class);
    private final ZoneId zoneId;
    private final String password;

    private IssuesFactoryFeatures(WorkbookWriterFeatures workbookWriterFeatures, Set<Hint> hints, ZoneId zoneId, String password) {
        this.workbookWriterFeatures = workbookWriterFeatures;
        this.hints.addAll(hints);
        this.zoneId = zoneId;
        this.password = password;
    }

    public WorkbookWriterFeatures getWorkbookWriterFeatures() {
        return this.workbookWriterFeatures;
    }

    public boolean isEnabled(Hint hint) {
        return this.hints.contains((Object)hint);
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public String getPassword() {
        return this.password;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private WorkbookWriterFeatures workbookWriterFeatures = WorkbookWriterFeatures.STANDARD_FAST;
        private final Set<Hint> hints = EnumSet.noneOf(Hint.class);
        private ZoneId zoneId = ZoneOffset.UTC;
        private String password = null;

        protected Builder() {
        }

        public Builder workbookWriterFeatures(WorkbookWriterFeatures features) {
            this.workbookWriterFeatures = features;
            return this;
        }

        public Builder hint(Hint hint) {
            this.hints.add(hint);
            return this;
        }

        public Builder zoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public IssuesFactoryFeatures build() {
            return new IssuesFactoryFeatures(this.workbookWriterFeatures, this.hints, this.zoneId, this.password);
        }
    }

    public static enum Hint {
        VERBOSE,
        PRETTY_PRINT,
        ODS_FAST,
        ODS_SIMPLE,
        POI_STREAMING;

    }
}

