/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.issues.Issue;
import cdc.issues.IssuesFactory;
import cdc.issues.IssuesFactoryFeatures;
import cdc.issues.answers.IssuesAndAnswers;
import cdc.util.events.ProgressController;
import java.io.File;
import java.io.IOException;
import java.util.List;

@FunctionalInterface
public interface IssuesReader {
    public IssuesAndAnswers load(File var1, boolean var2, ProgressController var3) throws IOException;

    default public List<Issue> load(File file, ProgressController controller) throws IOException {
        return this.load(file, false, controller).getIssues();
    }

    public static IssuesAndAnswers load(File file, boolean loadAnswers, ProgressController controller, IssuesFactoryFeatures features) throws IOException {
        IssuesFactory factory = new IssuesFactory(features);
        IssuesReader reader = factory.createIssuesReader(file);
        return reader.load(file, loadAnswers, controller);
    }

    public static List<Issue> load(File file, ProgressController controller, IssuesFactoryFeatures features) throws IOException {
        return IssuesReader.load(file, false, controller, features).getIssues();
    }
}

