/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.issues.IssuesFactory;
import cdc.issues.IssuesFactoryFeatures;
import cdc.issues.Project;
import cdc.issues.Snapshot;
import cdc.issues.answers.IssuesAndAnswers;
import cdc.util.events.ProgressController;
import cdc.util.lang.Checks;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public interface IssuesWriter {
    public static final Settings ALL_DATA_ANSWERS = Settings.builder().build();
    public static final Settings ALL_DATA_NO_ANSWERS = Settings.builder().hint(Settings.Hint.NO_ANSWERS).build();

    public void save(Project var1, Snapshot var2, Settings var3, File var4, ProgressController var5) throws IOException;

    default public void save(Project project, Snapshot snapshot, File file, ProgressController controller) throws IOException {
        this.save(project, snapshot, ALL_DATA_ANSWERS, file, controller);
    }

    public void save(IssuesAndAnswers var1, Settings var2, File var3, ProgressController var4) throws IOException;

    public static void save(IssuesAndAnswers issuesAndAnswers, Settings settings, File file, ProgressController controller, IssuesFactoryFeatures features) throws IOException {
        IssuesFactory factory = new IssuesFactory(features);
        IssuesWriter writer = factory.createIssuesWriter(file);
        writer.save(issuesAndAnswers, settings, file, controller);
    }

    public static void save(Project project, Snapshot snapshot, Settings settings, File file, ProgressController controller, IssuesFactoryFeatures features) throws IOException {
        IssuesFactory factory = new IssuesFactory(features);
        IssuesWriter writer = factory.createIssuesWriter(file);
        writer.save(project, snapshot, settings, file, controller);
    }

    public static class Settings {
        private final Set<Hint> hints;
        private final List<String> metas;

        protected Settings(Set<Hint> hints, List<String> metas) {
            this.hints = (Set)Checks.isNotNull(hints, (String)"hints");
            this.metas = (List)Checks.isNotNull(metas, (String)"metas");
        }

        public Set<Hint> getHints() {
            return this.hints;
        }

        public List<String> getMetas() {
            return this.metas;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private final Set<Hint> hints = EnumSet.noneOf(Hint.class);
            private final List<String> metas = new ArrayList<String>();

            protected Builder() {
            }

            public Builder hint(Hint hint) {
                this.hints.add(hint);
                return this;
            }

            public Builder meta(String meta) {
                this.metas.add(meta);
                return this;
            }

            public Settings build() {
                return new Settings(this.hints, this.metas);
            }
        }

        public static enum Hint {
            NO_PROJECT,
            NO_SNAPSHOT,
            NO_DOMAIN,
            NO_METAS,
            NO_ANSWERS;

        }
    }
}

