/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.locations;

import cdc.issues.locations.LocatedData;
import cdc.issues.locations.Location;
import cdc.util.lang.Checks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DefaultLocatedData<T>
implements LocatedData<T> {
    private final T data;
    private final List<Location> locations;

    public DefaultLocatedData(T data, Location location) {
        Checks.isNotNull((Object)location, (String)"location");
        this.data = data;
        ArrayList<Location> tmp = new ArrayList<Location>();
        tmp.add(location);
        this.locations = Collections.unmodifiableList(tmp);
    }

    public DefaultLocatedData(T data, Location ... locations) {
        Checks.isNotNullOrEmpty((Object[])locations, (String)"locations");
        this.data = data;
        ArrayList tmp = new ArrayList();
        Collections.addAll(tmp, locations);
        this.locations = Collections.unmodifiableList(tmp);
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public List<Location> getLocations() {
        return this.locations;
    }

    public int hashCode() {
        return Objects.hash(this.data, this.locations);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultLocatedData)) {
            return false;
        }
        DefaultLocatedData other = (DefaultLocatedData)object;
        return Objects.equals(this.data, other.data) && Objects.equals(this.locations, other.locations);
    }

    public String toString() {
        return "[" + this.data + ", " + this.locations + "]";
    }
}

