/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.Issue;
import cdc.issues.IssuesHandler;
import cdc.issues.locations.Location;
import cdc.issues.rules.ConfiguredRule;
import cdc.issues.rules.Rule;
import cdc.util.lang.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface IssuesDetector<T> {
    public Descriptor<T> getDescriptor();

    default public Class<T> getDataClass() {
        return this.getDescriptor().getDataClass();
    }

    public String getProject();

    public String getSnapshot();

    public Set<Rule> getEnabledRules();

    public Set<ConfiguredRule> getEnabledConfiguredRules();

    public void analyze(T var1, List<Location> var2, IssuesHandler<Issue> var3);

    default public void analyze(T data, Location location, IssuesHandler<Issue> issuesHandler) {
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(location);
        this.analyze(data, locations, issuesHandler);
    }

    public static String toString(IssuesDetector<?> detector) {
        StringBuilder builder = new StringBuilder();
        builder.append("IssuesDetector<").append(detector.getDataClass().getSimpleName()).append(">(");
        boolean first = true;
        for (ConfiguredRule crule : detector.getEnabledConfiguredRules()) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(crule);
        }
        builder.append(")");
        return builder.toString();
    }

    public static abstract class AbstractDescriptor<T>
    implements Descriptor<T> {
        private final Class<T> dataClass;
        private final Set<Rule> rules;

        protected AbstractDescriptor(Class<T> dataClass, Rule ... rules) {
            this.dataClass = dataClass;
            this.rules = Collections.unmodifiableSet(CollectionUtils.toSet((Object[])rules));
        }

        @Override
        public final Class<T> getDataClass() {
            return this.dataClass;
        }

        @Override
        public final Set<Rule> getSupportedRules() {
            return this.rules;
        }
    }

    public static interface Descriptor<T> {
        public Class<T> getDataClass();

        public Set<Rule> getSupportedRules();

        public IssuesDetector<T> create(String var1, String var2, Set<ConfiguredRule> var3);

        default public IssuesDetector<T> create(String project, String snapshot, ConfiguredRule ... configuredRules) {
            HashSet<ConfiguredRule> set = new HashSet<ConfiguredRule>();
            Collections.addAll(set, configuredRules);
            return this.create(project, snapshot, set);
        }

        default public IssuesDetector<T> create(String project, String snapshot, ConfiguredRule configuredRule) {
            HashSet<ConfiguredRule> configuredRules = new HashSet<ConfiguredRule>();
            configuredRules.add(configuredRule);
            return this.create(project, snapshot, configuredRules);
        }
    }
}

