/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.Issue;
import cdc.issues.IssuesHandler;
import cdc.issues.Project;
import cdc.issues.locations.LocatedData;
import cdc.issues.rules.ConfiguredRule;
import cdc.issues.rules.DataSource;
import cdc.issues.rules.IssuesDetector;
import cdc.issues.rules.Profile;
import cdc.issues.rules.Rule;
import cdc.util.events.ProgressController;
import cdc.util.events.ProgressSupplier;
import cdc.util.lang.Checks;
import cdc.util.lang.NotFoundException;
import java.util.HashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public interface RulesCatalog {
    public Set<String> getDomains();

    default public boolean hasDomain(String domain) {
        return this.getDomains().contains(domain);
    }

    public Set<Rule> getRules();

    default public boolean hasRule(Rule rule) {
        return this.getRules().contains(rule);
    }

    default public Set<Rule> getRules(String domain) {
        return this.getRules().stream().filter(rule -> rule.getDomain().equals(domain)).collect(Collectors.toSet());
    }

    public Set<IssuesDetector.Descriptor<?>> getDescriptors();

    public <T> Set<IssuesDetector.Descriptor<T>> getDescriptors(Class<T> var1);

    public <T> IssuesDetector.Descriptor<T> getDescriptorOrNull(Rule var1, Class<T> var2);

    default public <T> IssuesDetector.Descriptor<T> getDescriptor(Rule rule, Class<T> dataClass) {
        IssuesDetector.Descriptor<T> descriptor = this.getDescriptorOrNull(rule, dataClass);
        if (descriptor == null) {
            throw new NotFoundException("No descriptor found for [" + rule.getName() + ", " + dataClass.getCanonicalName() + "]");
        }
        return descriptor;
    }

    default public boolean hasDescriptor(Rule rule, Class<?> dataClass) {
        return this.getDescriptorOrNull(rule, dataClass) != null;
    }

    default public <T> IssuesDetector<T> createIssuesDetector(String project, String snapshot, ConfiguredRule configuredRule, Class<T> dataClass) {
        IssuesDetector.Descriptor<T> descriptor = this.getDescriptor(configuredRule.getRule(), dataClass);
        HashSet<ConfiguredRule> crules = new HashSet<ConfiguredRule>();
        crules.add(configuredRule);
        return descriptor.create(project, snapshot, crules);
    }

    default public <T> void apply(String project, String snapshot, ConfiguredRule configuredRule, Class<T> dataClass, Spliterator<LocatedData<T>> spliterator, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        IssuesDetector<T> detector = this.createIssuesDetector(project, snapshot, configuredRule, dataClass);
        RulesCatalog.apply(detector, spliterator, issuesHandler, controller);
    }

    default public <T> void apply(String project, String snapshot, Profile profile, DataSource<T> source, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        for (IssuesDetector.Descriptor<T> descriptor : this.getDescriptors(source.getDataClass())) {
            HashSet<Rule> rules = new HashSet<Rule>(profile.getEnabledRules());
            rules.retainAll(descriptor.getSupportedRules());
            if (rules.isEmpty()) continue;
            HashSet<ConfiguredRule> crules = new HashSet<ConfiguredRule>();
            for (Rule rule : rules) {
                ConfiguredRule crule = new ConfiguredRule(rule, profile.getRuleParams(rule));
                crules.add(crule);
            }
            IssuesDetector<T> detector = descriptor.create(project, snapshot, crules);
            RulesCatalog.apply(detector, source.getSpliterator(), issuesHandler, controller);
        }
    }

    default public void apply(Project project, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        for (DataSource<?> source : project.getDataSources()) {
            this.apply(project.getName(), project.getProfile().getName(), project.getProfile(), source, issuesHandler, controller);
        }
    }

    public static <T> void apply(IssuesDetector<T> detector, Spliterator<LocatedData<T>> spliterator, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        Checks.isNotNull(detector, (String)"detector");
        Checks.isNotNull(spliterator, (String)"spliterator");
        Checks.isNotNull(issuesHandler, (String)"issuesHandler");
        Checks.isNotNull((Object)controller, (String)"controller");
        ProgressSupplier progress = new ProgressSupplier(controller);
        progress.reset(spliterator.estimateSize(), IssuesDetector.toString(detector));
        Consumer<LocatedData> consumer = ld -> detector.analyze(ld.getData(), ld.getLocations(), issuesHandler);
        boolean next = true;
        while (next) {
            next = spliterator.tryAdvance(consumer);
            next = next && !controller.isCancelled();
            progress.incrementValue();
        }
    }
}

