/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.IssueId;
import cdc.issues.api.IssueLevel;
import cdc.issues.api.IssueLocation;
import cdc.util.lang.Checks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Issue<T> {
    private final IssueId<T> id;
    private final IssueLevel level;
    private final String description;

    protected Issue(IssueId<T> id, IssueLevel level, String description) {
        this.id = (IssueId)Checks.isNotNull(id, (String)"id");
        this.level = (IssueLevel)((Object)Checks.isNotNull((Object)((Object)level), (String)"level"));
        this.description = (String)Checks.isNotNull((Object)description, (String)"description");
    }

    protected Issue(T type, List<IssueLocation> locations, IssueLevel level, String description) {
        this(new IssueId<T>(type, locations.toArray(new IssueLocation[locations.size()])), level, description);
    }

    public IssueId<T> getId() {
        return this.id;
    }

    public T getType() {
        return this.id.getType();
    }

    public IssueLevel getLevel() {
        return this.level;
    }

    public String getDescription() {
        return this.description;
    }

    public IssueLocation[] getLocations() {
        return this.id.getLocations();
    }

    public IssueLocation getLocationAt(int index) {
        return this.id.getLocations()[index];
    }

    public <L extends IssueLocation> L getLocationAt(int index, Class<L> cls) {
        return (L)((IssueLocation)cls.cast(this.getLocationAt(index)));
    }

    public String toString() {
        return this.getType() + " " + (Object)((Object)this.getLevel()) + " " + this.getDescription() + " " + Arrays.toString(this.getLocations());
    }

    public static <T> Builder<T> builder(Class<T> typeClass) {
        return new Builder();
    }

    public static class Builder<T>
    extends AbstractIssueBuilder<Builder<T>, Issue<T>, T> {
        @Override
        protected Builder<T> self() {
            return this;
        }

        @Override
        public Issue<T> build() {
            return new Issue<Object>(this.type, this.locations, this.level, this.description);
        }
    }

    public static abstract class AbstractIssueBuilder<B extends AbstractIssueBuilder<B, I, T>, I extends Issue<T>, T> {
        protected T type;
        protected IssueLevel level;
        protected String description;
        protected final List<IssueLocation> locations = new ArrayList<IssueLocation>();

        protected AbstractIssueBuilder() {
        }

        protected abstract B self();

        public B type(T type) {
            this.type = type;
            return this.self();
        }

        public B addLocation(IssueLocation location) {
            this.locations.add(location);
            return this.self();
        }

        public B level(IssueLevel level) {
            this.level = level;
            return this.self();
        }

        public B description(String description) {
            this.description = description;
            return this.self();
        }

        public abstract I build();
    }
}

