/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.IssueLocation;
import cdc.util.lang.Checks;
import java.util.Arrays;

public class IssueId<T> {
    private final T type;
    private final IssueLocation[] locations;

    public IssueId(T type, IssueLocation[] locations) {
        this.type = Checks.isNotNull(type, (String)"type");
        this.locations = (IssueLocation[])((IssueLocation[])Checks.isNotNull((Object)locations, (String)"locations")).clone();
        if (locations.length == 0) {
            throw new IllegalArgumentException("Empty locations");
        }
    }

    public T getType() {
        return this.type;
    }

    public IssueLocation[] getLocations() {
        return (IssueLocation[])this.locations.clone();
    }

    public int hashCode() {
        return this.type.hashCode() + 31 * Arrays.hashCode(this.locations);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IssueId)) {
            return false;
        }
        IssueId other = (IssueId)object;
        return this.type.equals(other.type) && Arrays.equals(this.locations, other.locations);
    }

    public String toString() {
        return "[" + this.type + " " + Arrays.toString(this.locations) + "]";
    }
}

