/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.Issue;
import cdc.issues.api.IssueLocation;
import cdc.util.office.ss.WorkbookWriter;
import cdc.util.office.ss.WorkbookWriterFactory;
import cdc.util.tables.TableSection;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class IssuesWorkbookWriter {
    private final WorkbookWriterFactory factory = new WorkbookWriterFactory();

    public IssuesWorkbookWriter() {
        this.factory.setEnabled(WorkbookWriter.Feature.AUTO_SIZE_COLUMNS, true);
        this.factory.setEnabled(WorkbookWriter.Feature.AUTO_FILTER_COLUMNS, true);
    }

    public WorkbookWriterFactory getWorkbookWriterFactory() {
        return this.factory;
    }

    public void save(List<? extends Issue<?>> issues, File file) throws IOException {
        try (WorkbookWriter writer = this.factory.create(file);){
            writer.beginSheet("Issues");
            writer.beginRow(TableSection.HEADER);
            writer.addCells(new String[]{"Type", "Level", "Description", "# Locations", "Target Ids", "Paths"});
            for (Issue<?> issue : issues) {
                writer.beginRow(TableSection.DATA);
                writer.addCell(issue.getType());
                writer.addCell((Enum)issue.getLevel());
                writer.addCell(issue.getDescription());
                writer.addCell(issue.getLocations().length);
                StringBuilder ids = new StringBuilder();
                StringBuilder paths = new StringBuilder();
                boolean first = true;
                for (IssueLocation location : issue.getLocations()) {
                    if (first) {
                        first = false;
                    } else {
                        ids.append("\n");
                        paths.append("\n");
                    }
                    ids.append(location.getTargetId());
                    paths.append(location.getPath());
                }
                writer.addCell(ids.toString());
                writer.addCell(paths.toString());
            }
            writer.flush();
        }
    }
}

