/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.IssueId;
import cdc.issues.IssueSeverity;
import cdc.issues.IssueSeverityItem;
import cdc.issues.Params;
import cdc.issues.locations.Location;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class Issue {
    public static final Comparator<Issue> TIMESTAMP_COMPARATOR = Comparator.comparing(Issue::getTimestamp);
    private final Instant timestamp;
    private final IssueId id;
    private final String snapshot;
    private final IssueSeverity severity;
    private final String description;
    private final Params metas;

    protected Issue(Instant timestamp, String domain, String name, Params params, String project, List<? extends Location> locations, String snapshot, IssueSeverity severity, String description, Params metas) {
        this.timestamp = timestamp == null ? Instant.now() : timestamp;
        this.id = new IssueId(domain, name, params, project, locations.toArray(new Location[locations.size()]));
        this.snapshot = snapshot;
        this.severity = (IssueSeverity)((Object)Checks.isNotNull((Object)((Object)severity), (String)"severity"));
        this.description = (String)Checks.isNotNull((Object)description, (String)"description");
        this.metas = (Params)Checks.isNotNull((Object)metas, (String)"metas");
    }

    protected Issue(String domain, String name, Params params, String project, List<? extends Location> locations, String snapshot, IssueSeverity severity, String description, Params metas) {
        this(null, domain, name, params, project, locations, snapshot, severity, description, metas);
    }

    protected Issue(Instant timestamp, String domain, Enum<?> name, Params params, String project, List<? extends Location> locations, String snapshot, IssueSeverity severity, String description, Params metas) {
        this(timestamp, domain, name.name(), params, project, locations, snapshot, severity, description, metas);
    }

    protected Issue(String domain, Enum<?> name, Params params, String project, List<? extends Location> locations, String snapshot, IssueSeverity severity, String description, Params metas) {
        this(null, domain, name, params, project, locations, snapshot, severity, description, metas);
    }

    public final Instant getTimestamp() {
        return this.timestamp;
    }

    public IssueId getId() {
        return this.id;
    }

    public RuleId getRuleId() {
        return this.id.getRuleId();
    }

    public String getDomain() {
        return this.id.getDomain();
    }

    public String getName() {
        return this.id.getName();
    }

    public <T extends Enum<T>> T getName(Class<T> typeClass) {
        return this.id.getName(typeClass);
    }

    public Params getParams() {
        return this.id.getParams();
    }

    public String getProject() {
        return this.id.getProject();
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public final IssueSeverity getSeverity() {
        return this.severity;
    }

    public final String getDescription() {
        return this.description;
    }

    public Params getMetas() {
        return this.metas;
    }

    public Location[] getLocations() {
        return this.id.getLocations();
    }

    public final int getNumberOfLocations() {
        return this.id.getLocations().length;
    }

    public Location getLocationAt(int index) {
        return this.id.getLocations()[index];
    }

    public <L extends Location> L getLocationAt(int index, Class<L> cls) {
        return (L)((Location)cls.cast(this.getLocationAt(index)));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.id, this.severity, this.description, this.metas});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Issue other = (Issue)object;
        return Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.id, other.id) && Objects.equals(this.snapshot, other.snapshot) && this.severity == other.severity && Objects.equals(this.description, other.description) && Objects.equals(this.metas, other.metas);
    }

    public String toString() {
        return this.getTimestamp() + " - " + this.getDomain() + " - " + this.getName() + " - " + this.getParams() + " - " + this.getProject() + " - " + this.getSnapshot() + " - " + this.getSeverity() + " - " + this.getDescription() + " - " + Arrays.toString(this.getLocations()) + " - " + this.getMetas();
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<B extends Builder<B>> {
        protected Instant timestamp = null;
        protected String domain;
        protected String name;
        protected Params params = Params.NO_PARAMS;
        protected String project;
        protected String snapshot;
        protected IssueSeverity severity;
        protected String description = "";
        protected final List<Location> locations = new ArrayList<Location>();
        protected Params metas = Params.NO_PARAMS;

        protected Builder() {
        }

        protected B self() {
            return (B)this;
        }

        public B timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this.self();
        }

        public B ruleId(RuleId ruleId) {
            this.domain = ruleId.getDomain();
            this.name = ruleId.getName();
            return this.self();
        }

        public B domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B name(Enum<?> name) {
            this.name = name.name();
            if (this.severity == null && name instanceof IssueSeverityItem) {
                this.severity(((IssueSeverityItem)((Object)name)).getSeverity());
            }
            return this.self();
        }

        public B params(Params params) {
            this.params = params;
            return this.self();
        }

        public B project(String project) {
            this.project = project;
            return this.self();
        }

        public B addLocation(Location location) {
            this.locations.add(location);
            return this.self();
        }

        public B locations(Location ... locations) {
            this.locations.clear();
            Collections.addAll(this.locations, locations);
            return this.self();
        }

        public B locations(List<Location> locations) {
            this.locations.clear();
            this.locations.addAll(locations);
            return this.self();
        }

        public B snapshot(String snapshot) {
            this.snapshot = snapshot;
            return this.self();
        }

        public B severity(IssueSeverity severity) {
            this.severity = severity;
            return this.self();
        }

        public B description(String description) {
            Checks.isNotNull((Object)description, (String)"description");
            this.description = description;
            return this.self();
        }

        public B metas(Params metas) {
            this.metas = metas;
            return this.self();
        }

        public Issue build() {
            return new Issue(this.timestamp, this.domain, this.name, this.params, this.project, this.locations, this.snapshot, this.severity, this.description, this.metas);
        }
    }
}

