/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.Issue;
import cdc.issues.IssueSeverity;
import cdc.issues.IssuesHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VerboseIssuesHandler<I extends Issue>
implements IssuesHandler<I> {
    private static final Logger LOGGER = LogManager.getLogger(VerboseIssuesHandler.class);
    private final IssuesHandler<? super I> delegate;

    public VerboseIssuesHandler(IssuesHandler<? super I> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void issue(I issue) {
        if (((Issue)issue).getSeverity() == IssueSeverity.INFO) {
            LOGGER.info(issue);
        } else if (((Issue)issue).getSeverity() == IssueSeverity.MINOR || ((Issue)issue).getSeverity() == IssueSeverity.MAJOR) {
            LOGGER.warn(issue);
        } else if (((Issue)issue).getSeverity() == IssueSeverity.CRITICAL) {
            LOGGER.error(issue);
        } else if (((Issue)issue).getSeverity() == IssueSeverity.BLOCKER) {
            LOGGER.fatal(issue);
        }
        this.delegate.issue(issue);
    }
}

