/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.locations;

import cdc.issues.locations.AbstractLocation;
import cdc.issues.locations.Location;
import cdc.util.lang.Checks;

public class DefaultLocation
extends AbstractLocation {
    private final String path;
    private final String anchor;
    public static final String TAG = "DefaultLocation";

    public DefaultLocation(String path, String anchor) {
        this.path = (String)Checks.isNotNull((Object)path, (String)"path");
        this.anchor = anchor;
    }

    public DefaultLocation(String path) {
        this(path, null);
    }

    public DefaultLocation(Location other) {
        this(other.getPath(), other.getAnchor());
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getAnchor() {
        return this.anchor;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String path;
        private String anchor = null;

        protected Builder() {
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder anchor(String anchor) {
            this.anchor = anchor;
            return this;
        }

        public DefaultLocation build() {
            return new DefaultLocation(this.path, this.anchor);
        }
    }
}

