/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.answers.IssueResolution;
import cdc.issues.answers.IssueStatus;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IssueStatusTest {
    IssueStatusTest() {
    }

    private static void check(boolean expected, IssueStatus status, IssueResolution resolution) {
        Assertions.assertSame((Object)expected, (Object)status.isCompliantWith(resolution), (String)(status + " " + resolution));
    }

    @Test
    void testIsCompliantWith() {
        IssueStatusTest.check(true, IssueStatus.CLOSED, IssueResolution.FALSE_POSITIVE);
        IssueStatusTest.check(true, IssueStatus.CLOSED, IssueResolution.FIXED);
        IssueStatusTest.check(true, IssueStatus.CLOSED, IssueResolution.REMOVED);
        IssueStatusTest.check(false, IssueStatus.CLOSED, IssueResolution.UNRESOLVED);
        IssueStatusTest.check(true, IssueStatus.CLOSED, IssueResolution.WONT_FIX);
        IssueStatusTest.check(false, IssueStatus.CONFIRMED, IssueResolution.FALSE_POSITIVE);
        IssueStatusTest.check(false, IssueStatus.CONFIRMED, IssueResolution.FIXED);
        IssueStatusTest.check(false, IssueStatus.CONFIRMED, IssueResolution.REMOVED);
        IssueStatusTest.check(true, IssueStatus.CONFIRMED, IssueResolution.UNRESOLVED);
        IssueStatusTest.check(false, IssueStatus.CONFIRMED, IssueResolution.WONT_FIX);
        IssueStatusTest.check(false, IssueStatus.OPEN, IssueResolution.FALSE_POSITIVE);
        IssueStatusTest.check(false, IssueStatus.OPEN, IssueResolution.FIXED);
        IssueStatusTest.check(false, IssueStatus.OPEN, IssueResolution.REMOVED);
        IssueStatusTest.check(true, IssueStatus.OPEN, IssueResolution.UNRESOLVED);
        IssueStatusTest.check(false, IssueStatus.OPEN, IssueResolution.WONT_FIX);
        IssueStatusTest.check(false, IssueStatus.REOPENED, IssueResolution.FALSE_POSITIVE);
        IssueStatusTest.check(false, IssueStatus.REOPENED, IssueResolution.FIXED);
        IssueStatusTest.check(false, IssueStatus.REOPENED, IssueResolution.REMOVED);
        IssueStatusTest.check(true, IssueStatus.REOPENED, IssueResolution.UNRESOLVED);
        IssueStatusTest.check(false, IssueStatus.REOPENED, IssueResolution.WONT_FIX);
        IssueStatusTest.check(true, IssueStatus.RESOLVED, IssueResolution.FALSE_POSITIVE);
        IssueStatusTest.check(true, IssueStatus.RESOLVED, IssueResolution.FIXED);
        IssueStatusTest.check(false, IssueStatus.RESOLVED, IssueResolution.REMOVED);
        IssueStatusTest.check(false, IssueStatus.RESOLVED, IssueResolution.UNRESOLVED);
        IssueStatusTest.check(true, IssueStatus.RESOLVED, IssueResolution.WONT_FIX);
        IssueStatusTest.check(false, IssueStatus.WAITING, IssueResolution.FALSE_POSITIVE);
        IssueStatusTest.check(false, IssueStatus.WAITING, IssueResolution.FIXED);
        IssueStatusTest.check(false, IssueStatus.WAITING, IssueResolution.REMOVED);
        IssueStatusTest.check(true, IssueStatus.WAITING, IssueResolution.UNRESOLVED);
        IssueStatusTest.check(false, IssueStatus.WAITING, IssueResolution.WONT_FIX);
    }
}

