/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.answers.IssueResolution;
import cdc.issues.answers.IssueStatus;
import cdc.issues.answers.IssueTransition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IssueTransitionTest {
    IssueTransitionTest() {
    }

    @Test
    void testGetTargetResolution() {
        Assertions.assertSame((Object)IssueResolution.FALSE_POSITIVE, (Object)IssueTransition.CLOSE_AS_FALSE_POSITIVE.getTargetResolution());
        Assertions.assertSame((Object)IssueResolution.FIXED, (Object)IssueTransition.CLOSE_AS_FIXED.getTargetResolution());
        Assertions.assertSame((Object)IssueResolution.REMOVED, (Object)IssueTransition.CLOSE_AS_REMOVED.getTargetResolution());
        Assertions.assertSame((Object)IssueResolution.WONT_FIX, (Object)IssueTransition.CLOSE_AS_WONT_FIX.getTargetResolution());
        Assertions.assertSame((Object)IssueResolution.UNRESOLVED, (Object)IssueTransition.CONFIRM.getTargetResolution());
        Assertions.assertSame((Object)IssueResolution.UNRESOLVED, (Object)IssueTransition.OPEN.getTargetResolution());
        Assertions.assertSame((Object)IssueResolution.UNRESOLVED, (Object)IssueTransition.REOPEN.getTargetResolution());
        Assertions.assertSame((Object)IssueResolution.FALSE_POSITIVE, (Object)IssueTransition.RESOLVE_AS_FALSE_POSITIVE.getTargetResolution());
        Assertions.assertSame((Object)IssueResolution.FIXED, (Object)IssueTransition.RESOLVE_AS_FIXED.getTargetResolution());
        Assertions.assertSame((Object)IssueResolution.WONT_FIX, (Object)IssueTransition.RESOLVE_AS_WONT_FIX.getTargetResolution());
        Assertions.assertSame((Object)IssueResolution.UNRESOLVED, (Object)IssueTransition.WAIT.getTargetResolution());
    }

    @Test
    void testGetTargetStatus() {
        Assertions.assertSame((Object)IssueStatus.CLOSED, (Object)IssueTransition.CLOSE_AS_FALSE_POSITIVE.getTargetStatus());
        Assertions.assertSame((Object)IssueStatus.CLOSED, (Object)IssueTransition.CLOSE_AS_FIXED.getTargetStatus());
        Assertions.assertSame((Object)IssueStatus.CLOSED, (Object)IssueTransition.CLOSE_AS_REMOVED.getTargetStatus());
        Assertions.assertSame((Object)IssueStatus.CLOSED, (Object)IssueTransition.CLOSE_AS_WONT_FIX.getTargetStatus());
        Assertions.assertSame((Object)IssueStatus.CONFIRMED, (Object)IssueTransition.CONFIRM.getTargetStatus());
        Assertions.assertSame((Object)IssueStatus.OPEN, (Object)IssueTransition.OPEN.getTargetStatus());
        Assertions.assertSame((Object)IssueStatus.REOPENED, (Object)IssueTransition.REOPEN.getTargetStatus());
        Assertions.assertSame((Object)IssueStatus.RESOLVED, (Object)IssueTransition.RESOLVE_AS_FALSE_POSITIVE.getTargetStatus());
        Assertions.assertSame((Object)IssueStatus.RESOLVED, (Object)IssueTransition.RESOLVE_AS_FIXED.getTargetStatus());
        Assertions.assertSame((Object)IssueStatus.RESOLVED, (Object)IssueTransition.RESOLVE_AS_WONT_FIX.getTargetStatus());
        Assertions.assertSame((Object)IssueStatus.WAITING, (Object)IssueTransition.WAIT.getTargetStatus());
    }

    private static void checkIsValidSource(boolean expected, IssueTransition transition, IssueStatus status, IssueResolution resolution) {
        Assertions.assertSame((Object)expected, (Object)transition.isValidSource(status, resolution), (String)(transition + " " + status + " " + resolution));
    }

    @Test
    void testIsValidSourceCloseAsFalsePositive() {
        IssueTransition transition = IssueTransition.CLOSE_AS_FALSE_POSITIVE;
        for (IssueStatus status : IssueStatus.values()) {
            for (IssueResolution resolution : IssueResolution.values()) {
                if (status == IssueStatus.RESOLVED && resolution == IssueResolution.FALSE_POSITIVE) {
                    IssueTransitionTest.checkIsValidSource(true, transition, status, resolution);
                    continue;
                }
                IssueTransitionTest.checkIsValidSource(false, transition, status, resolution);
            }
        }
    }

    @Test
    void testIsValidSourceCloseAsWontFix() {
        IssueTransition transition = IssueTransition.CLOSE_AS_WONT_FIX;
        for (IssueStatus status : IssueStatus.values()) {
            for (IssueResolution resolution : IssueResolution.values()) {
                if (status == IssueStatus.RESOLVED && resolution == IssueResolution.WONT_FIX) {
                    IssueTransitionTest.checkIsValidSource(true, transition, status, resolution);
                    continue;
                }
                IssueTransitionTest.checkIsValidSource(false, transition, status, resolution);
            }
        }
    }

    @Test
    void testIsValidSourceCloseAsFixed() {
        IssueTransition transition = IssueTransition.CLOSE_AS_FIXED;
        for (IssueStatus status : IssueStatus.values()) {
            for (IssueResolution resolution : IssueResolution.values()) {
                if (status == IssueStatus.RESOLVED && resolution == IssueResolution.FIXED || status == IssueStatus.CONFIRMED && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.WAITING && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.OPEN && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.REOPENED && resolution == IssueResolution.UNRESOLVED) {
                    IssueTransitionTest.checkIsValidSource(true, transition, status, resolution);
                    continue;
                }
                IssueTransitionTest.checkIsValidSource(false, transition, status, resolution);
            }
        }
    }

    @Test
    void testIsValidSourceCloseAsRemoved() {
        IssueTransition transition = IssueTransition.CLOSE_AS_REMOVED;
        for (IssueStatus status : IssueStatus.values()) {
            for (IssueResolution resolution : IssueResolution.values()) {
                if (status == IssueStatus.RESOLVED && resolution == IssueResolution.FIXED || status == IssueStatus.RESOLVED && resolution == IssueResolution.FALSE_POSITIVE || status == IssueStatus.RESOLVED && resolution == IssueResolution.WONT_FIX || status == IssueStatus.CONFIRMED && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.WAITING && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.OPEN && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.REOPENED && resolution == IssueResolution.UNRESOLVED) {
                    IssueTransitionTest.checkIsValidSource(true, transition, status, resolution);
                    continue;
                }
                IssueTransitionTest.checkIsValidSource(false, transition, status, resolution);
            }
        }
    }

    @Test
    void testIsValidSourceResolveAsFalsePositive() {
        IssueTransition transition = IssueTransition.RESOLVE_AS_FALSE_POSITIVE;
        for (IssueStatus status : IssueStatus.values()) {
            for (IssueResolution resolution : IssueResolution.values()) {
                if (status == IssueStatus.RESOLVED && resolution == IssueResolution.FIXED || status == IssueStatus.RESOLVED && resolution == IssueResolution.WONT_FIX || status == IssueStatus.CONFIRMED && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.WAITING && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.OPEN && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.REOPENED && resolution == IssueResolution.UNRESOLVED) {
                    IssueTransitionTest.checkIsValidSource(true, transition, status, resolution);
                    continue;
                }
                IssueTransitionTest.checkIsValidSource(false, transition, status, resolution);
            }
        }
    }

    @Test
    void testIsValidSourceResolveAsWontFix() {
        IssueTransition transition = IssueTransition.RESOLVE_AS_WONT_FIX;
        for (IssueStatus status : IssueStatus.values()) {
            for (IssueResolution resolution : IssueResolution.values()) {
                if (status == IssueStatus.RESOLVED && resolution == IssueResolution.FIXED || status == IssueStatus.RESOLVED && resolution == IssueResolution.FALSE_POSITIVE || status == IssueStatus.CONFIRMED && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.WAITING && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.OPEN && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.REOPENED && resolution == IssueResolution.UNRESOLVED) {
                    IssueTransitionTest.checkIsValidSource(true, transition, status, resolution);
                    continue;
                }
                IssueTransitionTest.checkIsValidSource(false, transition, status, resolution);
            }
        }
    }

    @Test
    void testIsValidSourceResolveAsFixed() {
        IssueTransition transition = IssueTransition.RESOLVE_AS_FIXED;
        for (IssueStatus status : IssueStatus.values()) {
            for (IssueResolution resolution : IssueResolution.values()) {
                if (status == IssueStatus.RESOLVED && resolution == IssueResolution.WONT_FIX || status == IssueStatus.RESOLVED && resolution == IssueResolution.FALSE_POSITIVE || status == IssueStatus.CONFIRMED && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.WAITING && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.OPEN && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.REOPENED && resolution == IssueResolution.UNRESOLVED) {
                    IssueTransitionTest.checkIsValidSource(true, transition, status, resolution);
                    continue;
                }
                IssueTransitionTest.checkIsValidSource(false, transition, status, resolution);
            }
        }
    }

    @Test
    void testIsValidSourceConfirm() {
        IssueTransition transition = IssueTransition.CONFIRM;
        for (IssueStatus status : IssueStatus.values()) {
            for (IssueResolution resolution : IssueResolution.values()) {
                if (status == IssueStatus.RESOLVED && resolution == IssueResolution.WONT_FIX || status == IssueStatus.RESOLVED && resolution == IssueResolution.FALSE_POSITIVE || status == IssueStatus.RESOLVED && resolution == IssueResolution.FIXED || status == IssueStatus.WAITING && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.OPEN && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.REOPENED && resolution == IssueResolution.UNRESOLVED) {
                    IssueTransitionTest.checkIsValidSource(true, transition, status, resolution);
                    continue;
                }
                IssueTransitionTest.checkIsValidSource(false, transition, status, resolution);
            }
        }
    }

    @Test
    void testIsValidSourceWait() {
        IssueTransition transition = IssueTransition.WAIT;
        for (IssueStatus status : IssueStatus.values()) {
            for (IssueResolution resolution : IssueResolution.values()) {
                if (status == IssueStatus.RESOLVED && resolution == IssueResolution.WONT_FIX || status == IssueStatus.RESOLVED && resolution == IssueResolution.FALSE_POSITIVE || status == IssueStatus.RESOLVED && resolution == IssueResolution.FIXED || status == IssueStatus.CONFIRMED && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.OPEN && resolution == IssueResolution.UNRESOLVED || status == IssueStatus.REOPENED && resolution == IssueResolution.UNRESOLVED) {
                    IssueTransitionTest.checkIsValidSource(true, transition, status, resolution);
                    continue;
                }
                IssueTransitionTest.checkIsValidSource(false, transition, status, resolution);
            }
        }
    }

    @Test
    void testIsValidSourceOpen() {
        IssueTransition transition = IssueTransition.OPEN;
        for (IssueStatus status : IssueStatus.values()) {
            for (IssueResolution resolution : IssueResolution.values()) {
                IssueTransitionTest.checkIsValidSource(false, transition, status, resolution);
            }
        }
    }

    @Test
    void testIsValidSourceReopen() {
        IssueTransition transition = IssueTransition.REOPEN;
        for (IssueStatus status : IssueStatus.values()) {
            for (IssueResolution resolution : IssueResolution.values()) {
                if (status == IssueStatus.RESOLVED && resolution == IssueResolution.FIXED || status == IssueStatus.CLOSED && resolution != IssueResolution.UNRESOLVED) {
                    IssueTransitionTest.checkIsValidSource(true, transition, status, resolution);
                    continue;
                }
                IssueTransitionTest.checkIsValidSource(false, transition, status, resolution);
            }
        }
    }
}

