/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.rules.ConfiguredRule;
import cdc.issues.rules.IssuesDetector;
import cdc.issues.rules.Rule;
import cdc.util.lang.Checks;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractIssueDetector<T>
implements IssuesDetector<T> {
    protected final IssuesDetector.Factory<T> factory;
    protected final String project;
    protected final String snapshot;
    protected final Set<ConfiguredRule> enabledConfiguredRules;
    protected final Set<Rule> enabledRules;

    protected AbstractIssueDetector(IssuesDetector.Factory<T> factory, String project, String snapshot, Set<ConfiguredRule> configuredRules) {
        Checks.isNotNullOrEmpty(configuredRules, (String)"configuredRules");
        this.factory = (IssuesDetector.Factory)Checks.isNotNull(factory, (String)"factory");
        this.project = project;
        this.snapshot = snapshot;
        this.enabledConfiguredRules = Collections.unmodifiableSet(new HashSet<ConfiguredRule>(configuredRules));
        HashSet<Rule> rules = new HashSet<Rule>();
        for (ConfiguredRule crule : configuredRules) {
            if (!factory.getSupportedRules().contains(crule.getRule())) {
                throw new IllegalArgumentException("Non supported rule");
            }
            rules.add(crule.getRule());
        }
        this.enabledRules = Collections.unmodifiableSet(rules);
    }

    @Override
    public IssuesDetector.Factory<T> getFactory() {
        return this.factory;
    }

    @Override
    public final String getProject() {
        return this.project;
    }

    @Override
    public final String getSnapshot() {
        return this.snapshot;
    }

    @Override
    public final Set<Rule> getEnabledRules() {
        return this.enabledRules;
    }

    @Override
    public final Set<ConfiguredRule> getEnabledConfiguredRules() {
        return this.enabledConfiguredRules;
    }

    public String toString() {
        return IssuesDetector.toString(this);
    }
}

