/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.Params;
import cdc.issues.locations.Location;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class IssueId
implements Comparable<IssueId> {
    private final RuleId ruleId;
    private final Params params;
    private final String project;
    private final Location[] locations;
    private static final Comparator<String> STRING_COMPARATOR = Comparator.nullsFirst(Comparator.naturalOrder());

    @Deprecated(forRemoval=true)
    public IssueId(RuleId ruleId, Params params, String project, Location ... locations) {
        this.ruleId = (RuleId)Checks.isNotNull((Object)ruleId, (String)"ruleId");
        this.params = (Params)Checks.isNotNull((Object)params, (String)"params");
        this.project = project;
        this.locations = (Location[])((Location[])Checks.isNotNull((Object)locations, (String)"locations")).clone();
    }

    @Deprecated(forRemoval=true)
    public IssueId(String domain, String name, Params params, String project, Location ... locations) {
        this(new RuleId(domain, name), params, project, locations);
    }

    @Deprecated(forRemoval=true)
    public IssueId(RuleId ruleId, Params params, Location ... locations) {
        this(ruleId, params, (String)null, locations);
    }

    @Deprecated(forRemoval=true)
    public IssueId(String domain, String name, Params params, Location ... locations) {
        this(domain, name, params, (String)null, locations);
    }

    @Deprecated(forRemoval=true)
    public IssueId(String domain, Enum<?> name, Params params, String project, Location ... locations) {
        this(domain, name.name(), params, project, locations);
    }

    @Deprecated(forRemoval=true)
    public IssueId(String domain, Enum<?> name, Params params, Location ... locations) {
        this(domain, name, params, (String)null, locations);
    }

    public RuleId getRuleId() {
        return this.ruleId;
    }

    public String getDomain() {
        return this.ruleId.getDomain();
    }

    public String getName() {
        return this.ruleId.getName();
    }

    public <T extends Enum<T>> T getName(Class<T> cls) {
        return this.ruleId.getName(cls);
    }

    public Params getParams() {
        return this.params;
    }

    public String getProject() {
        return this.project;
    }

    public Location[] getLocations() {
        return (Location[])this.locations.clone();
    }

    public int hashCode() {
        return Objects.hash(this.ruleId, this.params, this.project) + 31 * Arrays.hashCode(this.locations);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IssueId)) {
            return false;
        }
        IssueId other = (IssueId)object;
        return this.ruleId.equals(other.ruleId) && Objects.equals(this.params, other.params) && Objects.equals(this.project, other.project) && Arrays.equals(this.locations, other.locations);
    }

    @Override
    public int compareTo(IssueId other) {
        int ruleIdCmp = this.ruleId.compareTo(other.ruleId);
        if (ruleIdCmp != 0) {
            return ruleIdCmp;
        }
        int paramsCmp = this.params.compareTo(other.params);
        if (paramsCmp != 0) {
            return paramsCmp;
        }
        int projectCmp = STRING_COMPARATOR.compare(this.project, other.project);
        if (projectCmp != 0) {
            return projectCmp;
        }
        return Arrays.compare((Comparable[])this.locations, (Comparable[])other.locations);
    }

    public String toString() {
        return "[" + this.ruleId + " " + this.params + " " + this.project + " " + Arrays.toString(this.locations) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String domain;
        private String name;
        private Params params = Params.NO_PARAMS;
        private String project;
        private Location[] locations = new Location[0];

        private Builder() {
        }

        public Builder ruleId(RuleId ruleId) {
            this.domain = ruleId.getDomain();
            this.name = ruleId.getName();
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder name(Enum<?> name) {
            this.name = name.name();
            return this;
        }

        public Builder params(Params params) {
            this.params = params;
            return this;
        }

        public Builder project(String project) {
            this.project = project;
            return this;
        }

        public Builder locations(Location ... locations) {
            Checks.isNotNull((Object)locations, (String)"locations");
            this.locations = locations;
            return this;
        }

        public Builder locations(List<? extends Location> locations) {
            Checks.isNotNull(locations, (String)"locations");
            this.locations = locations.toArray(new Location[locations.size()]);
            return this;
        }

        public IssueId build() {
            return new IssueId(this.domain, this.name, this.params, this.project, this.locations);
        }
    }
}

