/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.issues.io.IssuesFormat;
import cdc.issues.io.IssuesIoFactoryFeatures;
import cdc.issues.io.IssuesReader;
import cdc.issues.io.IssuesStreamWriter;
import cdc.issues.io.IssuesWriter;
import cdc.issues.io.OutSettings;
import cdc.util.lang.Checks;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.Introspection;
import java.io.File;
import java.io.OutputStream;

public class IssuesIoFactory {
    private final IssuesIoFactoryFeatures features;

    public IssuesIoFactory(IssuesIoFactoryFeatures features) {
        this.features = features;
    }

    public IssuesIoFactoryFeatures getFeatures() {
        return this.features;
    }

    public boolean canExportTo(File file) {
        if (file == null) {
            return false;
        }
        return IssuesFormat.from(file) != null;
    }

    public IssuesStreamWriter createIssuesStreamWriter(File file, OutSettings settings) {
        Checks.isNotNull((Object)file, (String)"file");
        IssuesFormat format = IssuesFormat.from(file);
        if (format != null) {
            switch (format) {
                case CSV: 
                case ODS: 
                case XLS: 
                case XLSM: 
                case XLSX: {
                    return this.createIssuesStreamWriter("cdc.issues.core.io.WorkbookIssuesStreamWriter", file, settings);
                }
                case JSON: {
                    return this.createIssuesStreamWriter("cdc.issues.core.io.JsonIssuesStreamWriter", file, settings);
                }
                case XML: {
                    return this.createIssuesStreamWriter("cdc.issues.core.io.XmlIssuesStreamWriter", file, settings);
                }
            }
        }
        throw new IllegalArgumentException("Can not create an IssuesStreamWriter for " + file);
    }

    public IssuesStreamWriter createIssuesStreamWriter(OutputStream out, IssuesFormat format, OutSettings settings) {
        if (format != null) {
            switch (format) {
                case CSV: 
                case ODS: 
                case XLS: 
                case XLSM: 
                case XLSX: {
                    return this.createIssuesStreamWriter("cdc.issues.core.io.WorkbookIssuesStreamWriter", out, format, settings);
                }
                case JSON: {
                    return this.createIssuesStreamWriter("cdc.issues.core.io.JsonIssuesStreamWriter", out, format, settings);
                }
                case XML: {
                    return this.createIssuesStreamWriter("cdc.issues.core.io.XmlIssuesStreamWriter", out, format, settings);
                }
            }
        }
        throw new IllegalArgumentException("Can not create an IssuesStreamWriter for " + format);
    }

    public IssuesWriter createIssuesWriter(File file) {
        Checks.isNotNull((Object)file, (String)"file");
        IssuesFormat format = IssuesFormat.from(file);
        if (format != null) {
            switch (format) {
                case CSV: 
                case ODS: 
                case XLS: 
                case XLSM: 
                case XLSX: 
                case JSON: 
                case XML: {
                    return this.createIssuesWriter("cdc.issues.core.io.IssuesWriterImpl", file);
                }
            }
        }
        throw new IllegalArgumentException("Can not create an IssuesWriter for " + file);
    }

    public IssuesWriter createIssuesWriter(OutputStream out, IssuesFormat format) {
        if (format != null) {
            switch (format) {
                case CSV: 
                case ODS: 
                case XLS: 
                case XLSM: 
                case XLSX: 
                case JSON: 
                case XML: {
                    return this.createIssuesWriter("cdc.issues.core.io.IssuesWriterImpl", out, format);
                }
            }
        }
        throw new IllegalArgumentException("Can not create an IssuesWriter for " + format);
    }

    private IssuesStreamWriter createIssuesStreamWriter(String className, File file, OutSettings settings) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesStreamWriter.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{File.class, OutSettings.class, IssuesIoFactoryFeatures.class};
        return (IssuesStreamWriter)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{file, settings, this.getFeatures()});
    }

    private IssuesStreamWriter createIssuesStreamWriter(String className, OutputStream out, IssuesFormat format, OutSettings settings) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesStreamWriter.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{OutputStream.class, IssuesFormat.class, OutSettings.class, IssuesIoFactoryFeatures.class};
        return (IssuesStreamWriter)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{out, format, settings, this.getFeatures()});
    }

    private IssuesWriter createIssuesWriter(String className, File file) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesWriter.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{File.class, IssuesIoFactoryFeatures.class};
        return (IssuesWriter)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{file, this.getFeatures()});
    }

    private IssuesWriter createIssuesWriter(String className, OutputStream out, IssuesFormat format) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesWriter.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{OutputStream.class, IssuesFormat.class, IssuesIoFactoryFeatures.class};
        return (IssuesWriter)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{out, format, this.getFeatures()});
    }

    public boolean canImportFrom(File file) {
        if (file == null) {
            return false;
        }
        return IssuesFormat.from(file) != null;
    }

    public IssuesReader createIssuesReader(File file) {
        Checks.isNotNull((Object)file, (String)"file");
        IssuesFormat format = IssuesFormat.from(file);
        if (format != null) {
            switch (format) {
                case CSV: 
                case ODS: 
                case XLS: 
                case XLSM: 
                case XLSX: {
                    return this.createIssuesReader("cdc.issues.core.io.WorkbookIssuesReader", file);
                }
                case JSON: {
                    return this.createIssuesReader("cdc.issues.core.io.JsonIssuesReader", file);
                }
                case XML: {
                    return this.createIssuesReader("cdc.issues.core.io.XmlIssuesReader", file);
                }
            }
        }
        throw new IllegalArgumentException("Can not create an IssuesReader for " + file);
    }

    private IssuesReader createIssuesReader(String className, File file) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesReader.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{File.class, IssuesIoFactoryFeatures.class};
        return (IssuesReader)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{file, this.getFeatures()});
    }
}

