/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.FormalParams;
import cdc.issues.IssueSeverity;
import cdc.issues.IssueSeverityItem;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class Rule {
    private final RuleId id;
    private final Set<IssueSeverity> severities;
    private final String description;
    private final FormalParams params;
    public static final Comparator<Rule> ID_COMPARATOR = Comparator.comparing(Rule::getId);

    protected Rule(RuleId id, Set<IssueSeverity> severities, String description, FormalParams params) {
        this.id = (RuleId)Checks.isNotNull((Object)id, (String)"id");
        this.severities = Collections.unmodifiableSet((Set)Checks.isNotNullOrEmpty(severities, (String)"severities"));
        this.description = (String)Checks.isNotNull((Object)description, (String)"description");
        this.params = (FormalParams)Checks.isNotNull((Object)params, (String)"params");
    }

    public RuleId getId() {
        return this.id;
    }

    public String getDomain() {
        return this.id.getDomain();
    }

    public String getName() {
        return this.id.getName();
    }

    public <T extends Enum<T>> T getName(Class<T> cls) {
        return this.id.getName(cls);
    }

    public Set<IssueSeverity> getSeverities() {
        return this.severities;
    }

    public String getDescription() {
        return this.description;
    }

    public FormalParams getParams() {
        return this.params;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.severities, this.description, this.params);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)object;
        return Objects.equals(this.id, other.id) && Objects.equals(this.severities, other.severities) && Objects.equals(this.description, other.description) && Objects.equals(this.params, other.params);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String domain;
        private String name;
        private final Set<IssueSeverity> severities = EnumSet.noneOf(IssueSeverity.class);
        private String description = "";
        private FormalParams params = FormalParams.NO_PARAMS;

        protected Builder() {
        }

        public Builder id(RuleId id) {
            this.domain = id.getDomain();
            this.name = id.getName();
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder name(Enum<?> name) {
            this.name = name.name();
            if (this.severities.isEmpty() && name instanceof IssueSeverityItem) {
                this.addSeverity(((IssueSeverityItem)((Object)name)).getSeverity());
            }
            return this;
        }

        public Builder addSeverity(IssueSeverity severity) {
            Checks.isNotNull((Object)((Object)severity), (String)"severity");
            this.severities.add(severity);
            return this;
        }

        public Builder addSeverities(Collection<IssueSeverity> severities) {
            Checks.isNotNull(severities, (String)"severities");
            this.severities.addAll(severities);
            return this;
        }

        public Builder addSeverities(IssueSeverity ... severities) {
            Checks.isNotNull((Object)severities, (String)"severities");
            Collections.addAll(this.severities, severities);
            return this;
        }

        public Builder description(String description) {
            Checks.isNotNull((Object)description, (String)"description");
            this.description = description;
            return this;
        }

        public Builder params(FormalParams params) {
            this.params = params;
            return this;
        }

        public Rule build() {
            return new Rule(new RuleId(this.domain, this.name), this.severities, this.description, this.params);
        }
    }
}

