/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.locations;

import cdc.issues.locations.AbstractLocation;
import cdc.util.lang.Checks;
import cdc.util.strings.StringUtils;

public class TextFileLocation
extends AbstractLocation {
    private final String systemId;
    private final int lineNumber;
    private final int columnNumber;
    public static final String TAG = "TextFileLocation";
    private static final String SEPARATOR = ":";

    protected TextFileLocation(String systemId, int lineNumber, int columnNumber) {
        this.systemId = (String)Checks.isNotNull((Object)systemId, (String)"systemId");
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        if (lineNumber < 1 && columnNumber >= 1) {
            throw new IllegalArgumentException("Non compliant numbers");
        }
    }

    public static TextFileLocation create(String systemId, String anchor) {
        return TextFileLocation.builder().systemId(systemId).anchor(anchor).build();
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getPath() {
        return this.getSystemId();
    }

    @Override
    public String getAnchor() {
        if (this.lineNumber >= 1) {
            if (this.columnNumber >= 1) {
                return this.lineNumber + SEPARATOR + this.columnNumber;
            }
            return Integer.toString(this.lineNumber);
        }
        return "";
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String systemId;
        private int lineNumber = 0;
        private int columnNumber = 0;

        protected Builder() {
        }

        public Builder systemId(String systemId) {
            this.systemId = systemId;
            return this;
        }

        public Builder lineNumber(int lineNumber) {
            this.lineNumber = Math.max(0, lineNumber);
            return this;
        }

        public Builder columnNumber(int columnNumber) {
            this.columnNumber = Math.max(0, columnNumber);
            return this;
        }

        public Builder anchor(String anchor) {
            if (StringUtils.isNullOrEmpty((String)anchor)) {
                this.lineNumber = 0;
                this.columnNumber = 0;
            } else {
                int pos = anchor.indexOf(TextFileLocation.SEPARATOR);
                if (pos > 0) {
                    this.lineNumber = Integer.parseInt(anchor.substring(0, pos));
                    this.columnNumber = Integer.parseInt(anchor.substring(pos + TextFileLocation.SEPARATOR.length()));
                } else {
                    this.lineNumber = Integer.parseInt(anchor);
                }
            }
            return this;
        }

        public TextFileLocation build() {
            return new TextFileLocation(this.systemId, this.lineNumber, this.columnNumber);
        }
    }
}

