/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.rules.IssuesDetector;
import cdc.issues.rules.Rule;
import cdc.issues.rules.RuleId;
import cdc.issues.rules.RulesCatalog;
import cdc.util.lang.Checks;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public class CompositeRulesCatalog
implements RulesCatalog {
    private final Set<RulesCatalog> catalogs = new LinkedHashSet<RulesCatalog>();

    public CompositeRulesCatalog add(RulesCatalog catalog) {
        Checks.isNotNull((Object)catalog, (String)"catalog");
        this.catalogs.add(catalog);
        return this;
    }

    @Override
    public Set<String> getDomains() {
        HashSet<String> set = new HashSet<String>();
        for (RulesCatalog catalog : this.catalogs) {
            set.addAll(catalog.getDomains());
        }
        return set;
    }

    @Override
    public Set<Rule> getRules() {
        HashSet<Rule> set = new HashSet<Rule>();
        for (RulesCatalog catalog : this.catalogs) {
            set.addAll(catalog.getRules());
        }
        return set;
    }

    @Override
    public Optional<Rule> getRule(RuleId id) {
        for (RulesCatalog catalog : this.catalogs) {
            Optional<Rule> rule = catalog.getRule(id);
            if (!rule.isPresent()) continue;
            return rule;
        }
        return Optional.empty();
    }

    @Override
    public Set<IssuesDetector.Factory<?>> getFactories() {
        HashSet set = new HashSet();
        for (RulesCatalog catalog : this.catalogs) {
            set.addAll(catalog.getFactories());
        }
        return set;
    }

    @Override
    public <T> Set<IssuesDetector.Factory<T>> getFactories(Class<T> dataClass) {
        HashSet<IssuesDetector.Factory<T>> set = new HashSet<IssuesDetector.Factory<T>>();
        for (RulesCatalog catalog : this.catalogs) {
            set.addAll(catalog.getFactories(dataClass));
        }
        return set;
    }

    @Override
    public <T> Optional<IssuesDetector.Factory<T>> getFactory(Rule rule, Class<T> dataClass) {
        for (RulesCatalog catalog : this.catalogs) {
            Optional<IssuesDetector.Factory<T>> factory = catalog.getFactory(rule, dataClass);
            if (!factory.isPresent()) continue;
            return factory;
        }
        return Optional.empty();
    }
}

