/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.Issue;
import cdc.issues.IssuesHandler;
import cdc.issues.Project;
import cdc.issues.locations.LocatedData;
import cdc.issues.rules.ConfiguredRule;
import cdc.issues.rules.DataSource;
import cdc.issues.rules.IssuesDetector;
import cdc.issues.rules.Profile;
import cdc.issues.rules.Rule;
import cdc.issues.rules.RuleId;
import cdc.util.events.ProgressController;
import cdc.util.events.ProgressSupplier;
import cdc.util.lang.Checks;
import cdc.util.lang.NotFoundException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public interface RulesCatalog {
    public Set<String> getDomains();

    default public boolean hasDomain(String domain) {
        return this.getDomains().contains(domain);
    }

    public Set<Rule> getRules();

    public Optional<Rule> getRule(RuleId var1);

    default public boolean hasRule(Rule rule) {
        return this.getRules().contains(rule);
    }

    default public boolean hasRule(RuleId id) {
        return this.getRule(id).isPresent();
    }

    default public Set<Rule> getRules(String domain) {
        return this.getRules().stream().filter(rule -> rule.getDomain().equals(domain)).collect(Collectors.toSet());
    }

    public Set<IssuesDetector.Factory<?>> getFactories();

    public <T> Set<IssuesDetector.Factory<T>> getFactories(Class<T> var1);

    public <T> Optional<IssuesDetector.Factory<T>> getFactory(Rule var1, Class<T> var2);

    default public boolean hasDescriptor(Rule rule, Class<?> dataClass) {
        return this.getFactory(rule, dataClass).isPresent();
    }

    default public <T> IssuesDetector<T> createIssuesDetector(String project, String snapshot, ConfiguredRule configuredRule, Class<T> dataClass) {
        IssuesDetector.Factory<T> factory = this.getFactory(configuredRule.getRule(), dataClass).orElseThrow(() -> new NotFoundException("No factory for " + configuredRule.getRule().getName()));
        HashSet<ConfiguredRule> crules = new HashSet<ConfiguredRule>();
        crules.add(configuredRule);
        return factory.create(project, snapshot, crules);
    }

    default public <T> void apply(String project, String snapshot, ConfiguredRule configuredRule, Class<T> dataClass, Spliterator<LocatedData<T>> spliterator, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        IssuesDetector<T> detector = this.createIssuesDetector(project, snapshot, configuredRule, dataClass);
        RulesCatalog.apply(detector, spliterator, issuesHandler, controller);
    }

    default public <T> void apply(String project, String snapshot, Profile profile, DataSource<T> source, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        for (IssuesDetector.Factory<T> factory : this.getFactories(source.getDataClass())) {
            HashSet<Rule> rules = new HashSet<Rule>(profile.getEnabledRules());
            rules.retainAll(factory.getSupportedRules());
            if (rules.isEmpty()) continue;
            HashSet<ConfiguredRule> crules = new HashSet<ConfiguredRule>();
            for (Rule rule : rules) {
                ConfiguredRule crule = new ConfiguredRule(rule, profile.getParams(rule));
                crules.add(crule);
            }
            IssuesDetector<T> detector = factory.create(project, snapshot, crules);
            RulesCatalog.apply(detector, source.getSpliterator(), issuesHandler, controller);
        }
    }

    default public void apply(Project project, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        for (DataSource<?> source : project.getDataSources()) {
            this.apply(project.getName(), project.getProfile().orElseThrow().getName(), project.getProfile().orElseThrow(), source, issuesHandler, controller);
        }
    }

    public static <T> void apply(IssuesDetector<T> detector, Spliterator<LocatedData<T>> spliterator, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        Checks.isNotNull(detector, (String)"detector");
        Checks.isNotNull(spliterator, (String)"spliterator");
        Checks.isNotNull(issuesHandler, (String)"issuesHandler");
        Checks.isNotNull((Object)controller, (String)"controller");
        ProgressSupplier progress = new ProgressSupplier(controller);
        progress.reset(spliterator.estimateSize(), IssuesDetector.toString(detector));
        Consumer<LocatedData> consumer = ld -> detector.analyze(ld.getData(), ld.getLocations(), issuesHandler);
        boolean next = true;
        while (next) {
            next = spliterator.tryAdvance(consumer);
            next = next && !controller.isCancelled();
            progress.incrementValue();
        }
    }
}

