/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.util.lang.Checks;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class FormalParams {
    private static final String NAME = "name";
    public static final FormalParams NO_PARAMS = FormalParams.builder().build();
    private final Map<String, String> map = new HashMap<String, String>();

    private FormalParams(Builder builder) {
        for (Map.Entry<String, String> entry : builder.map.entrySet()) {
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<String> getNames() {
        return this.map.keySet();
    }

    public List<String> getSortedNames() {
        return this.map.keySet().stream().sorted().collect(Collectors.toList());
    }

    public String getDescription(String name) {
        return this.map.get(name);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FormalParams)) {
            return false;
        }
        FormalParams other = (FormalParams)object;
        return this.map.equals(other.map);
    }

    public String toString() {
        return this.getSortedNames().stream().map(name -> name + ":" + this.getDescription((String)name)).collect(Collectors.joining(" ", "[", "]"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, String> map = new HashMap<String, String>();

        private Builder() {
        }

        public Builder param(String name, String description) {
            Checks.isNotNull((Object)name, (String)FormalParams.NAME);
            this.map.put(name, description);
            return this;
        }

        public FormalParams build() {
            return new FormalParams(this);
        }
    }
}

