/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.Issue;
import cdc.issues.api.IssueLevel;
import cdc.issues.api.IssuesHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultIssuesHandler
implements IssuesHandler<Object> {
    private static final Logger LOGGER = LogManager.getLogger(DefaultIssuesHandler.class);
    private final boolean verbose;
    public static final DefaultIssuesHandler VERBOSE = new DefaultIssuesHandler(true);
    public static final DefaultIssuesHandler QUIET = new DefaultIssuesHandler(false);

    public static <T> IssuesHandler<T> get(Class<T> cls, boolean verbose) {
        if (verbose) {
            DefaultIssuesHandler tmp = VERBOSE;
            return tmp;
        }
        DefaultIssuesHandler tmp = QUIET;
        return tmp;
    }

    protected DefaultIssuesHandler(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void issue(Issue<? extends Object> issue) {
        if (this.verbose) {
            if (issue.getLevel() == IssueLevel.INFO) {
                LOGGER.info(issue);
            } else if (issue.getLevel() == IssueLevel.WARNING) {
                LOGGER.warn(issue);
            } else if (issue.getLevel() == IssueLevel.ERROR) {
                LOGGER.error(issue);
            } else if (issue.getLevel() == IssueLevel.FATAL) {
                LOGGER.fatal(issue);
            }
        }
    }
}

