/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.Issue;
import cdc.issues.api.IssueLocation;
import cdc.util.lang.Checks;
import cdc.util.office.ss.WorkbookWriter;
import cdc.util.office.ss.WorkbookWriterFactory;
import cdc.util.office.ss.WorkbookWriterFeatures;
import cdc.util.tables.TableSection;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;

public class IssuesWorkbookWriter {
    private final WorkbookWriterFactory factory = new WorkbookWriterFactory();
    private ZoneId zoneId = ZoneOffset.UTC;

    public WorkbookWriterFactory getWorkbookWriterFactory() {
        return this.factory;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        Checks.isNotNull((Object)zoneId, (String)"zoneId");
        this.zoneId = zoneId;
    }

    public void save(List<? extends Issue<?>> issues, File file, WorkbookWriterFeatures features) throws IOException {
        try (WorkbookWriter writer = this.factory.create(file, features);){
            writer.beginSheet("Issues");
            writer.beginRow(TableSection.HEADER);
            writer.addCells(new String[]{"Timestamp", "Type", "Level", "Description", "# Locations", "Target Ids", "Paths"});
            for (Issue<?> issue : issues) {
                writer.beginRow(TableSection.DATA);
                writer.addCell(LocalDateTime.ofInstant(issue.getTimestamp(), this.zoneId));
                writer.addCell(issue.getType());
                writer.addCell((Enum)issue.getLevel());
                writer.addCell(issue.getDescription());
                writer.addCell(issue.getLocations().length);
                StringBuilder ids = new StringBuilder();
                StringBuilder paths = new StringBuilder();
                boolean first = true;
                for (IssueLocation location : issue.getLocations()) {
                    if (first) {
                        first = false;
                    } else {
                        ids.append('\n');
                        paths.append('\n');
                    }
                    ids.append(location.getTargetId());
                    paths.append(location.getPath() == null ? "" : location.getPath());
                }
                writer.addCell(ids.toString());
                writer.addCell(paths.toString());
            }
            writer.flush();
        }
    }
}

