/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api.locations;

import cdc.issues.api.IssueLocation;
import cdc.util.lang.Checks;
import java.util.Objects;

public class DefaultIssueLocation
implements IssueLocation {
    private final String targetId;
    private final String path;

    private DefaultIssueLocation(String targetId, String path) {
        this.targetId = (String)Checks.isNotNull((Object)targetId, (String)"targetId");
        this.path = path;
    }

    @Override
    public String getTargetId() {
        return this.targetId;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return Objects.hash(this.targetId, this.path);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultIssueLocation)) {
            return false;
        }
        DefaultIssueLocation other = (DefaultIssueLocation)object;
        return this.targetId.equals(other.targetId) && Objects.equals(this.path, other.path);
    }

    public String toString() {
        return IssueLocation.toString(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String targetId;
        private String path = null;

        private Builder() {
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public DefaultIssueLocation build() {
            return new DefaultIssueLocation(this.targetId, this.path);
        }
    }
}

