/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.Issue;
import cdc.issues.api.IssueLevel;
import cdc.issues.api.IssuesHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class IssuesCollector<T>
implements IssuesHandler<T> {
    private final List<Issue<? extends T>> issues = new ArrayList<Issue<? extends T>>();
    private final IssuesHandler<T> delegate;

    public IssuesCollector(IssuesHandler<T> delegate) {
        this.delegate = delegate;
    }

    public IssuesCollector() {
        this.delegate = null;
    }

    public IssuesHandler<T> getDelegate() {
        return this.delegate;
    }

    public void clear() {
        this.issues.clear();
    }

    public List<Issue<? extends T>> getIssues() {
        return this.issues;
    }

    public List<Issue<? extends T>> getIssues(IssueLevel level) {
        return this.issues.stream().filter(i -> i.getIssueLevel() == level).collect(Collectors.toList());
    }

    @Override
    public void issue(Issue<? extends T> issue) {
        this.issues.add(issue);
        if (this.delegate != null) {
            this.delegate.issue(issue);
        }
    }
}

